/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.Binds;
import dagger.Module;
import dagger.internal.codegen.BindingMethodValidator;
import dagger.internal.codegen.BindsTypeChecker;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequestValidator;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class BindsMethodValidator
extends BindingMethodValidator {
    private final DaggerTypes types;
    private final BindsTypeChecker bindsTypeChecker;

    @Inject
    BindsMethodValidator(DaggerElements elements, DaggerTypes types, DependencyRequestValidator dependencyRequestValidator) {
        super(elements, types, Binds.class, (Iterable<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class, ProducerModule.class), dependencyRequestValidator, BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.RUNTIME_EXCEPTION, BindingMethodValidator.AllowsMultibindings.ALLOWS_MULTIBINDINGS, BindingMethodValidator.AllowsScoping.ALLOWS_SCOPING);
        this.types = types;
        this.bindsTypeChecker = new BindsTypeChecker(types, elements);
    }

    @Override
    protected void checkMethod(ValidationReport.Builder<ExecutableElement> builder) {
        super.checkMethod(builder);
        this.checkParameters(builder);
    }

    @Override
    protected void checkParameters(ValidationReport.Builder<ExecutableElement> builder) {
        ExecutableElement method = builder.getSubject();
        if (method.getParameters().size() != 1) {
            builder.addError(this.bindingMethods("must have exactly one parameter, whose type is assignable to the return type", new Object[0]));
        } else {
            super.checkParameters(builder);
        }
    }

    @Override
    protected void checkParameter(ValidationReport.Builder<ExecutableElement> builder, VariableElement parameter) {
        super.checkParameter(builder, parameter);
        ExecutableElement method = builder.getSubject();
        TypeMirror leftHandSide = this.boxIfNecessary(method.getReturnType());
        TypeMirror rightHandSide = parameter.asType();
        ContributionType contributionType = ContributionType.fromBindingMethod(method);
        if (contributionType.equals((Object)ContributionType.SET_VALUES) && !SetType.isSet(leftHandSide)) {
            builder.addError("@Binds @ElementsIntoSet methods must return a Set and take a Set parameter");
        }
        if (!this.bindsTypeChecker.isAssignable(rightHandSide, leftHandSide, contributionType)) {
            builder.addError("@Binds methods' parameter type must be assignable to the return type");
        }
    }

    private TypeMirror boxIfNecessary(TypeMirror maybePrimitive) {
        if (maybePrimitive.getKind().isPrimitive()) {
            return this.types.boxedClass(MoreTypes.asPrimitiveType(maybePrimitive)).asType();
        }
        return maybePrimitive;
    }
}

