/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.AutoValue_BindingNode;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingDeclarationFormatter;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.OptionalBindingDeclaration;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.model.BindingKind;
import dagger.model.ComponentPath;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.Scope;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@AutoValue
abstract class BindingNode
implements dagger.model.Binding {
    private BindingDeclarationFormatter bindingDeclarationFormatter;

    BindingNode() {
    }

    static BindingNode create(ComponentPath component, Binding delegate, ImmutableSet<MultibindingDeclaration> multibindingDeclarations, ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations, ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations, BindingDeclarationFormatter bindingDeclarationFormatter) {
        AutoValue_BindingNode node = new AutoValue_BindingNode(component, delegate, multibindingDeclarations, optionalBindingDeclarations, subcomponentDeclarations);
        node.bindingDeclarationFormatter = (BindingDeclarationFormatter)Preconditions.checkNotNull((Object)bindingDeclarationFormatter);
        return node;
    }

    abstract Binding delegate();

    abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    abstract ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations();

    abstract ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations();

    final Iterable<BindingDeclaration> associatedDeclarations() {
        return Iterables.concat(this.multibindingDeclarations(), this.optionalBindingDeclarations(), this.subcomponentDeclarations());
    }

    public Key key() {
        return this.delegate().key();
    }

    public ImmutableSet<DependencyRequest> dependencies() {
        return this.delegate().dependencies();
    }

    public Optional<Element> bindingElement() {
        return this.delegate().bindingElement();
    }

    public Optional<TypeElement> contributingModule() {
        return this.delegate().contributingModule();
    }

    public boolean requiresModuleInstance() {
        return this.delegate().requiresModuleInstance();
    }

    public Optional<Scope> scope() {
        return this.delegate().scope();
    }

    public boolean isNullable() {
        return this.delegate().isNullable();
    }

    public boolean isProduction() {
        return this.delegate().bindingType().equals((Object)BindingType.PRODUCTION);
    }

    public BindingKind kind() {
        return this.delegate().kind();
    }

    public final String toString() {
        return this.bindingDeclarationFormatter.format(this.delegate());
    }
}

