/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;

enum ModuleKind {
    MODULE(Module.class, Provides.class),
    PRODUCER_MODULE(ProducerModule.class, Produces.class);

    private final Class<? extends Annotation> moduleAnnotation;
    private final Class<? extends Annotation> methodAnnotation;

    static ImmutableSet<Class<? extends Annotation>> annotationsFor(Set<ModuleKind> kinds) {
        return kinds.stream().map(ModuleKind::annotation).collect(DaggerStreams.toImmutableSet());
    }

    static Optional<ModuleKind> forAnnotatedElement(TypeElement element) {
        EnumSet<ModuleKind> kinds = EnumSet.noneOf(ModuleKind.class);
        for (ModuleKind kind : ModuleKind.values()) {
            if (!MoreElements.isAnnotationPresent(element, kind.annotation())) continue;
            kinds.add(kind);
        }
        if (kinds.size() > 1) {
            throw new IllegalArgumentException(element + " cannot be annotated with more than one of " + ModuleKind.annotationsFor(kinds));
        }
        return kinds.stream().findAny();
    }

    static void checkIsModule(TypeElement moduleElement) {
        Preconditions.checkArgument((boolean)ModuleKind.forAnnotatedElement(moduleElement).isPresent());
    }

    private ModuleKind(Class<? extends Annotation> moduleAnnotation, Class<? extends Annotation> methodAnnotation) {
        this.moduleAnnotation = moduleAnnotation;
        this.methodAnnotation = methodAnnotation;
    }

    AnnotationMirror getModuleAnnotation(TypeElement element) {
        Optional<AnnotationMirror> result = DaggerElements.getAnnotationMirror(element, this.moduleAnnotation);
        Preconditions.checkArgument((boolean)result.isPresent(), (String)"annotation %s is not present on type %s", this.moduleAnnotation, (Object)element);
        return result.get();
    }

    Class<? extends Annotation> annotation() {
        return this.moduleAnnotation;
    }

    Class<? extends Annotation> methodAnnotation() {
        return this.methodAnnotation;
    }

    ImmutableSet<ModuleKind> legalIncludedModuleKinds() {
        switch (this) {
            case MODULE: {
                return Sets.immutableEnumSet((Enum)MODULE, (Enum[])new ModuleKind[0]);
            }
            case PRODUCER_MODULE: {
                return Sets.immutableEnumSet((Enum)MODULE, (Enum[])new ModuleKind[]{PRODUCER_MODULE});
            }
        }
        throw new AssertionError((Object)this);
    }
}

