/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingGraphConverter;
import dagger.internal.codegen.BindingGraphFactory;
import dagger.internal.codegen.BindingGraphValidator;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentCreatorValidator;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentDescriptorValidator;
import dagger.internal.codegen.ComponentKind;
import dagger.internal.codegen.ComponentValidator;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.TypeCheckingProcessingStep;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class ComponentProcessingStep
extends TypeCheckingProcessingStep<TypeElement> {
    private final Messager messager;
    private final ComponentValidator componentValidator;
    private final ComponentCreatorValidator creatorValidator;
    private final ComponentDescriptorValidator componentDescriptorValidator;
    private final ComponentDescriptor.Factory componentDescriptorFactory;
    private final BindingGraphFactory bindingGraphFactory;
    private final SourceFileGenerator<BindingGraph> componentGenerator;
    private final BindingGraphConverter bindingGraphConverter;
    private final BindingGraphValidator bindingGraphValidator;
    private final CompilerOptions compilerOptions;
    private ImmutableSet<Element> subcomponentElements;
    private ImmutableSet<Element> subcomponentBuilderElements;
    private ImmutableMap<Element, ValidationReport<TypeElement>> builderReportsByComponent;
    private ImmutableMap<Element, ValidationReport<TypeElement>> builderReportsBySubcomponent;
    private ImmutableMap<Element, ValidationReport<TypeElement>> reportsBySubcomponent;

    @Inject
    ComponentProcessingStep(Messager messager, ComponentValidator componentValidator, ComponentCreatorValidator creatorValidator, ComponentDescriptorValidator componentDescriptorValidator, ComponentDescriptor.Factory componentDescriptorFactory, BindingGraphFactory bindingGraphFactory, SourceFileGenerator<BindingGraph> componentGenerator, BindingGraphConverter bindingGraphConverter, BindingGraphValidator bindingGraphValidator, CompilerOptions compilerOptions) {
        super(MoreElements::asType);
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.creatorValidator = creatorValidator;
        this.componentDescriptorValidator = componentDescriptorValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.bindingGraphFactory = bindingGraphFactory;
        this.componentGenerator = componentGenerator;
        this.bindingGraphConverter = bindingGraphConverter;
        this.bindingGraphValidator = bindingGraphValidator;
        this.compilerOptions = compilerOptions;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ComponentKind.allComponentAndBuilderAnnotations();
    }

    @Override
    public ImmutableSet<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        this.subcomponentElements = ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, ComponentKind.annotationsFor(ComponentKind.subcomponentKinds()));
        this.subcomponentBuilderElements = ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, ComponentKind.builderAnnotationsFor(ComponentKind.subcomponentKinds()));
        ImmutableSet.Builder rejectedElements = ImmutableSet.builder();
        this.builderReportsByComponent = this.processBuilders((Set<? extends Element>)ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, ComponentKind.builderAnnotationsFor(ComponentKind.rootComponentKinds())), (ImmutableSet.Builder<Element>)rejectedElements);
        this.builderReportsBySubcomponent = this.processBuilders((Set<? extends Element>)this.subcomponentBuilderElements, (ImmutableSet.Builder<Element>)rejectedElements);
        this.reportsBySubcomponent = this.processSubcomponents((Set<? extends Element>)this.subcomponentElements, (Set<? extends Element>)this.subcomponentBuilderElements, (ImmutableSet.Builder<Element>)rejectedElements);
        return rejectedElements.addAll(super.process(elementsByAnnotation)).build();
    }

    @Override
    protected void process(TypeElement element, ImmutableSet<Class<? extends Annotation>> annotations) {
        if (!Collections.disjoint(annotations, ComponentKind.annotationsFor(ComponentKind.rootComponentKinds()))) {
            ComponentValidator.ComponentValidationReport validationReport = this.componentValidator.validate(element, (Set<? extends Element>)this.subcomponentElements, (Set<? extends Element>)this.subcomponentBuilderElements);
            validationReport.report().printMessagesTo(this.messager);
            if (!this.isClean(validationReport)) {
                return;
            }
            ComponentDescriptor componentDescriptor = this.componentDescriptorFactory.forTypeElement(element);
            ValidationReport<TypeElement> componentDescriptorReport = this.componentDescriptorValidator.validate(componentDescriptor);
            componentDescriptorReport.printMessagesTo(this.messager);
            if (!componentDescriptorReport.isClean()) {
                return;
            }
            BindingGraph bindingGraph = this.bindingGraphFactory.create(componentDescriptor);
            if (this.isValid(bindingGraph)) {
                this.generateComponent(bindingGraph);
            }
        }
        if (this.compilerOptions.aheadOfTimeSubcomponents() && !Collections.disjoint(annotations, ComponentKind.annotationsFor(ComponentKind.subcomponentKinds()))) {
            if (!this.subcomponentIsClean(element)) {
                return;
            }
            ComponentDescriptor componentDescriptor = this.componentDescriptorFactory.forTypeElement(element);
            BindingGraph bindingGraph = this.bindingGraphFactory.create(componentDescriptor);
            if (this.isValid(bindingGraph)) {
                this.generateComponent(bindingGraph);
            }
        }
    }

    private boolean isValid(BindingGraph bindingGraph) {
        dagger.model.BindingGraph modelGraph = this.bindingGraphConverter.convert(bindingGraph, false);
        return this.bindingGraphValidator.isValid(modelGraph);
    }

    private void generateComponent(BindingGraph bindingGraph) {
        this.componentGenerator.generate(bindingGraph, this.messager);
    }

    static ImmutableSet<Element> getElementsFromAnnotations(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation, Set<Class<? extends Annotation>> annotations) {
        return ImmutableSet.copyOf((Collection)Multimaps.filterKeys(elementsByAnnotation, (Predicate)Predicates.in(annotations)).values());
    }

    private ImmutableMap<Element, ValidationReport<TypeElement>> processBuilders(Set<? extends Element> builderElements, ImmutableSet.Builder<Element> rejectedElements) {
        HashMap<Element, ValidationReport<TypeElement>> reports = new HashMap<Element, ValidationReport<TypeElement>>();
        for (Element element : builderElements) {
            try {
                ValidationReport<TypeElement> report = this.creatorValidator.validate(MoreElements.asType(element));
                report.printMessagesTo(this.messager);
                reports.put(element.getEnclosingElement(), report);
            }
            catch (TypeNotPresentException e) {
                rejectedElements.add((Object)element);
            }
        }
        return ImmutableMap.copyOf(reports);
    }

    private ImmutableMap<Element, ValidationReport<TypeElement>> processSubcomponents(Set<? extends Element> subcomponentElements, Set<? extends Element> subcomponentBuilderElements, ImmutableSet.Builder<Element> rejectedElements) {
        ImmutableMap.Builder reports = ImmutableMap.builder();
        for (Element element : subcomponentElements) {
            try {
                ComponentValidator.ComponentValidationReport report = this.componentValidator.validate(MoreElements.asType(element), subcomponentElements, subcomponentBuilderElements);
                report.report().printMessagesTo(this.messager);
                reports.put((Object)element, report.report());
            }
            catch (TypeNotPresentException e) {
                rejectedElements.add((Object)element);
            }
        }
        return reports.build();
    }

    private boolean isClean(ComponentValidator.ComponentValidationReport report) {
        TypeElement component = report.report().subject();
        ValidationReport<TypeElement> componentReport = report.report();
        if (!componentReport.isClean()) {
            return false;
        }
        ValidationReport builderReport = (ValidationReport)this.builderReportsByComponent.get((Object)component);
        if (builderReport != null && !builderReport.isClean()) {
            return false;
        }
        for (Element element : report.referencedSubcomponents()) {
            if (this.subcomponentIsClean(element)) continue;
            return false;
        }
        return true;
    }

    private boolean subcomponentIsClean(Element subcomponentElement) {
        ValidationReport subcomponentBuilderReport = (ValidationReport)this.builderReportsBySubcomponent.get((Object)subcomponentElement);
        if (subcomponentBuilderReport != null && !subcomponentBuilderReport.isClean()) {
            return false;
        }
        ValidationReport subcomponentReport = (ValidationReport)this.reportsBySubcomponent.get((Object)subcomponentElement);
        return subcomponentReport == null || subcomponentReport.isClean();
    }
}

