/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.Component;
import dagger.Module;
import dagger.Subcomponent;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.ModuleKind;
import dagger.producers.ProducerModule;
import dagger.producers.ProductionComponent;
import dagger.producers.ProductionSubcomponent;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;

enum ComponentKind {
    COMPONENT(Component.class, Optional.of(Component.Builder.class), true, false),
    SUBCOMPONENT(Subcomponent.class, Optional.of(Subcomponent.Builder.class), false, false),
    PRODUCTION_COMPONENT(ProductionComponent.class, Optional.of(ProductionComponent.Builder.class), true, true),
    PRODUCTION_SUBCOMPONENT(ProductionSubcomponent.class, Optional.of(ProductionSubcomponent.Builder.class), false, true),
    MODULE(Module.class, Optional.empty(), true, false),
    PRODUCER_MODULE(ProducerModule.class, Optional.empty(), true, true);

    private static final ImmutableSet<ComponentKind> ROOT_COMPONENT_KINDS;
    private static final ImmutableSet<ComponentKind> SUBCOMPONENT_KINDS;
    private final Class<? extends Annotation> annotation;
    private final Optional<Class<? extends Annotation>> builderAnnotation;
    private final boolean isRoot;
    private final boolean production;

    static ImmutableSet<ComponentKind> rootComponentKinds() {
        return ROOT_COMPONENT_KINDS;
    }

    static ImmutableSet<ComponentKind> subcomponentKinds() {
        return SUBCOMPONENT_KINDS;
    }

    static ImmutableSet<Class<? extends Annotation>> allComponentAndBuilderAnnotations() {
        return Arrays.stream(ComponentKind.values()).filter(kind -> !kind.isForModuleValidation()).flatMap(kind -> Stream.of(kind.annotation(), kind.builderAnnotation().get())).collect(DaggerStreams.toImmutableSet());
    }

    static ImmutableSet<Class<? extends Annotation>> annotationsFor(Set<ComponentKind> kinds) {
        return ComponentKind.annotationsFor(kinds, kind -> Optional.of(kind.annotation()));
    }

    private static ImmutableSet<Class<? extends Annotation>> annotationsFor(Set<ComponentKind> kinds, Function<ComponentKind, Optional<Class<? extends Annotation>>> annotationFunction) {
        return kinds.stream().map(annotationFunction).flatMap(DaggerStreams.presentValues()).collect(DaggerStreams.toImmutableSet());
    }

    static ImmutableSet<Class<? extends Annotation>> builderAnnotationsFor(Set<ComponentKind> kinds) {
        return ComponentKind.annotationsFor(kinds, ComponentKind::builderAnnotation);
    }

    static Optional<ComponentKind> forAnnotatedElement(TypeElement element) {
        return ComponentKind.forAnnotatedElement(element, kind -> Optional.of(kind.annotation()));
    }

    private static Optional<ComponentKind> forAnnotatedElement(TypeElement element, Function<ComponentKind, Optional<Class<? extends Annotation>>> annotationFunction) {
        EnumSet<ComponentKind> kinds = EnumSet.noneOf(ComponentKind.class);
        for (ComponentKind kind : ComponentKind.values()) {
            if (!annotationFunction.apply(kind).filter(annotation -> MoreElements.isAnnotationPresent(element, annotation)).isPresent()) continue;
            kinds.add(kind);
        }
        if (kinds.size() > 1) {
            throw new IllegalArgumentException(element + " cannot be annotated with more than one of " + ComponentKind.annotationsFor(kinds, annotationFunction));
        }
        return kinds.stream().findAny();
    }

    static Optional<ComponentKind> forAnnotatedBuilderElement(TypeElement element) {
        return ComponentKind.forAnnotatedElement(element, ComponentKind::builderAnnotation);
    }

    private ComponentKind(Class<? extends Annotation> annotation, Optional<Class<? extends Annotation>> builderAnnotation, boolean isRoot, boolean production) {
        this.annotation = annotation;
        this.builderAnnotation = builderAnnotation;
        this.isRoot = isRoot;
        this.production = production;
    }

    Class<? extends Annotation> annotation() {
        return this.annotation;
    }

    Optional<Class<? extends Annotation>> builderAnnotation() {
        return this.builderAnnotation;
    }

    ImmutableSet<ModuleKind> legalModuleKinds() {
        return this.isProducer() ? Sets.immutableEnumSet(EnumSet.allOf(ModuleKind.class)) : Sets.immutableEnumSet((Enum)ModuleKind.MODULE, (Enum[])new ModuleKind[0]);
    }

    ImmutableSet<ComponentKind> legalSubcomponentKinds() {
        return this.isProducer() ? Sets.immutableEnumSet((Enum)PRODUCTION_SUBCOMPONENT, (Enum[])new ComponentKind[0]) : Sets.immutableEnumSet((Enum)SUBCOMPONENT, (Enum[])new ComponentKind[]{PRODUCTION_SUBCOMPONENT});
    }

    boolean isRoot() {
        return this.isRoot;
    }

    boolean isProducer() {
        return this.production;
    }

    boolean isForModuleValidation() {
        switch (this) {
            case MODULE: 
            case PRODUCER_MODULE: {
                return true;
            }
        }
        return false;
    }

    static {
        ROOT_COMPONENT_KINDS = Arrays.stream(ComponentKind.values()).filter(kind -> !kind.isForModuleValidation()).filter(kind -> kind.isRoot()).collect(DaggerStreams.toImmutableSet());
        SUBCOMPONENT_KINDS = Arrays.stream(ComponentKind.values()).filter(kind -> !kind.isForModuleValidation()).filter(kind -> !kind.isRoot()).collect(DaggerStreams.toImmutableSet());
    }
}

