/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Preconditions;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentCreatorDescriptor;
import dagger.internal.codegen.ComponentCreatorImplementation;
import dagger.internal.codegen.ComponentCreatorImplementationFactory;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ComponentImplementationFactory;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementExpressions;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.MethodSignature;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.ModifiableBindingType;
import dagger.internal.codegen.Optionals;
import dagger.internal.codegen.ParentComponent;
import dagger.internal.codegen.TopLevelImplementationComponent;
import dagger.model.Key;
import dagger.producers.CancellationPolicy;
import dagger.producers.internal.CancellationListener;
import dagger.producers.internal.Producers;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

abstract class ComponentImplementationBuilder {
    private static final String MAY_INTERRUPT_IF_RUNNING = "mayInterruptIfRunning";
    private static final int STATEMENTS_PER_METHOD = 100;
    private static final String CANCELLATION_LISTENER_METHOD_NAME = "onProducerFutureCancelled";
    @Inject
    BindingGraph graph;
    @Inject
    ComponentBindingExpressions bindingExpressions;
    @Inject
    ComponentRequirementExpressions componentRequirementExpressions;
    @Inject
    ComponentImplementation componentImplementation;
    @Inject
    ComponentCreatorImplementationFactory componentCreatorImplementationFactory;
    @Inject
    DaggerTypes types;
    @Inject
    DaggerElements elements;
    @Inject
    CompilerOptions compilerOptions;
    @Inject
    ComponentImplementationFactory componentImplementationFactory;
    @Inject
    TopLevelImplementationComponent topLevelImplementationComponent;
    private boolean done;

    ComponentImplementationBuilder() {
    }

    final ComponentImplementation build() {
        com.google.common.base.Preconditions.checkState((!this.done ? 1 : 0) != 0, (String)"ComponentImplementationBuilder has already built the ComponentImplementation for [%s].", (Object)this.componentImplementation.name());
        this.setSupertype();
        this.componentImplementation.setCreatorImplementation(this.componentCreatorImplementationFactory.create(this.componentImplementation));
        this.componentImplementation.creatorImplementation().map(ComponentCreatorImplementation::spec).ifPresent(this::addCreatorClass);
        MoreElements.getLocalAndInheritedMethods(this.graph.componentTypeElement(), this.types, this.elements).forEach(method -> this.componentImplementation.claimMethodName(method.getSimpleName()));
        this.componentImplementation.superclassImplementation().ifPresent(superclassImplementation -> superclassImplementation.getAllModifiableMethodNames().forEach(this.componentImplementation::claimMethodName));
        this.addFactoryMethods();
        this.addInterfaceMethods();
        this.addChildComponents();
        this.implementModifiableModuleMethods();
        this.addConstructorAndInitializationMethods();
        if (this.graph.componentDescriptor().kind().isProducer()) {
            this.addCancellationListenerImplementation();
        }
        if (this.componentImplementation.isAbstract() && !this.componentImplementation.baseImplementation().isPresent()) {
            this.componentImplementation.addAnnotation(this.compilerOptions.toGenerationOptionsAnnotation());
        }
        this.done = true;
        return this.componentImplementation;
    }

    private void setSupertype() {
        if (this.componentImplementation.superclassImplementation().isPresent()) {
            this.componentImplementation.addSuperclass(this.componentImplementation.superclassImplementation().get().name());
        } else {
            this.componentImplementation.addSupertype(this.graph.componentTypeElement());
        }
    }

    protected abstract void addCreatorClass(TypeSpec var1);

    protected abstract void addFactoryMethods();

    protected void addInterfaceMethods() {
        ImmutableListMultimap componentMethodsBySignature = Multimaps.index(this.graph.componentDescriptor().entryPointMethods(), this::getMethodSignature);
        for (List methodsWithSameSignature : Multimaps.asMap((ListMultimap)componentMethodsBySignature).values()) {
            ComponentDescriptor.ComponentMethodDescriptor anyOneMethod = (ComponentDescriptor.ComponentMethodDescriptor)methodsWithSameSignature.stream().findAny().get();
            MethodSpec methodSpec = this.bindingExpressions.getComponentMethod(anyOneMethod);
            if (anyOneMethod.dependencyRequest().isPresent() && this.componentImplementation.getModifiableBindingMethod(BindingRequest.bindingRequest(anyOneMethod.dependencyRequest().get())).isPresent()) {
                com.google.common.base.Preconditions.checkState((this.componentImplementation.isAbstract() && !this.componentImplementation.isNested() ? 1 : 0) != 0);
                this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.COMPONENT_METHOD, methodSpec.toBuilder().addModifiers(new Modifier[]{Modifier.FINAL}).build());
                continue;
            }
            ModifiableBindingType modifiableBindingType = this.bindingExpressions.modifiableBindingExpressions().registerComponentMethodIfModifiable(anyOneMethod, methodSpec);
            if (!modifiableBindingType.hasBaseClassImplementation()) continue;
            this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.COMPONENT_METHOD, methodSpec);
        }
    }

    private void addCancellationListenerImplementation() {
        ImmutableList<CodeBlock> cancellationStatements;
        this.componentImplementation.addSupertype(this.elements.getTypeElement(CancellationListener.class));
        this.componentImplementation.claimMethodName(CANCELLATION_LISTENER_METHOD_NAME);
        ImmutableList parameters = ImmutableList.of((Object)ParameterSpec.builder(Boolean.TYPE, (String)MAY_INTERRUPT_IF_RUNNING, (Modifier[])new Modifier[0]).build());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)CANCELLATION_LISTENER_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameters((Iterable)parameters);
        if (this.componentImplementation.superclassImplementation().isPresent()) {
            methodBuilder.addStatement("super.$L($L)", new Object[]{CANCELLATION_LISTENER_METHOD_NAME, MAY_INTERRUPT_IF_RUNNING});
        }
        if ((cancellationStatements = this.cancellationStatements()).size() < 100) {
            methodBuilder.addCode(CodeBlocks.concat(cancellationStatements)).build();
        } else {
            ImmutableList<MethodSpec> cancelProducersMethods = this.createPartitionedMethods("cancelProducers", (Iterable<ParameterSpec>)parameters, (List<CodeBlock>)cancellationStatements, methodName -> MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}));
            for (MethodSpec cancelProducersMethod : cancelProducersMethods) {
                methodBuilder.addStatement("$N($L)", new Object[]{cancelProducersMethod, MAY_INTERRUPT_IF_RUNNING});
                this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.CANCELLATION_LISTENER_METHOD, cancelProducersMethod);
            }
        }
        Optional<CodeBlock> cancelParentStatement = this.cancelParentStatement();
        cancelParentStatement.ifPresent(arg_0 -> ((MethodSpec.Builder)methodBuilder).addCode(arg_0));
        if (cancellationStatements.isEmpty() && !cancelParentStatement.isPresent() && this.componentImplementation.superclassImplementation().isPresent()) {
            return;
        }
        this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.CANCELLATION_LISTENER_METHOD, methodBuilder.build());
    }

    private ImmutableList<CodeBlock> cancellationStatements() {
        ImmutableList cancellationKeys = this.componentImplementation.getCancellableProducerKeys().reverse();
        ImmutableList.Builder cancellationStatements = ImmutableList.builder();
        for (Key cancellationKey : cancellationKeys) {
            cancellationStatements.add((Object)CodeBlock.of((String)"$T.cancel($L, $N);", (Object[])new Object[]{Producers.class, this.bindingExpressions.getDependencyExpression(BindingRequest.bindingRequest(cancellationKey, FrameworkType.PRODUCER_NODE), this.componentImplementation.name()).codeBlock(), MAY_INTERRUPT_IF_RUNNING}));
        }
        return cancellationStatements.build();
    }

    protected Optional<CodeBlock> cancelParentStatement() {
        return Optional.empty();
    }

    private void implementModifiableModuleMethods() {
        if (this.componentImplementation.isAbstract()) {
            return;
        }
        this.componentImplementation.getAllModifiableModuleMethods().forEach(this::implementModifiableModuleMethod);
    }

    private void implementModifiableModuleMethod(ComponentRequirement module, String methodName) {
        this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.MODIFIABLE_BINDING_METHOD, MethodSpec.methodBuilder((String)methodName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(TypeName.get((TypeMirror)module.type())).addStatement(this.componentRequirementExpressions.getExpression(module).getModifiableModuleMethodExpression(this.componentImplementation.name())).build());
    }

    private MethodSignature getMethodSignature(ComponentDescriptor.ComponentMethodDescriptor method) {
        return MethodSignature.forComponentMethod(method, MoreTypes.asDeclared(this.graph.componentTypeElement().asType()), this.types);
    }

    private void addChildComponents() {
        for (BindingGraph subgraph : this.graph.subgraphs()) {
            this.componentImplementation.addChild(subgraph.componentDescriptor(), this.buildChildImplementation(subgraph));
        }
    }

    private ComponentImplementation buildChildImplementation(BindingGraph childGraph) {
        ComponentImplementation childImplementation = this.compilerOptions.aheadOfTimeSubcomponents() ? this.abstractInnerSubcomponent(childGraph) : this.concreteSubcomponent(childGraph);
        return this.topLevelImplementationComponent.currentImplementationSubcomponentBuilder().componentImplementation(childImplementation).bindingGraph(childGraph).parentBuilder(Optional.of(this)).parentBindingExpressions(Optional.of(this.bindingExpressions)).parentRequirementExpressions(Optional.of(this.componentRequirementExpressions)).build().subcomponentBuilder().build();
    }

    private ComponentImplementation abstractInnerSubcomponent(BindingGraph childGraph) {
        return new ComponentImplementation(this.componentImplementation, childGraph, Optional.of(this.componentImplementationFactory.findChildSuperclassImplementation(childGraph.componentDescriptor(), this.componentImplementation)), Modifier.PROTECTED, this.componentImplementation.isAbstract() ? Modifier.ABSTRACT : Modifier.FINAL);
    }

    private ComponentImplementation concreteSubcomponent(BindingGraph childGraph) {
        return new ComponentImplementation(this.componentImplementation, childGraph, Optional.empty(), Modifier.PRIVATE, Modifier.FINAL);
    }

    private void addConstructorAndInitializationMethods() {
        MethodSpec.Builder constructor = this.componentConstructorBuilder();
        if (!this.componentImplementation.isAbstract()) {
            this.implementInitializationMethod(constructor, this.initializationParameters());
        } else if (this.componentImplementation.hasInitializations()) {
            this.addConfigureInitializationMethod();
        }
        this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.CONSTRUCTOR, constructor.build());
    }

    private MethodSpec.Builder componentConstructorBuilder() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{this.componentImplementation.isAbstract() ? Modifier.PROTECTED : Modifier.PRIVATE});
    }

    private void implementInitializationMethod(MethodSpec.Builder initializationMethod, ImmutableMap<ComponentRequirement, ParameterSpec> initializationParameters) {
        initializationMethod.addParameters((Iterable)initializationParameters.values());
        initializationMethod.addCode(CodeBlocks.concat(this.componentImplementation.getComponentRequirementInitializations()));
        this.componentImplementation.superConfigureInitializationMethod().ifPresent(superConfigureInitializationMethod -> this.addSuperConfigureInitializationCall(initializationMethod, initializationParameters, (ComponentImplementation.ConfigureInitializationMethod)superConfigureInitializationMethod));
        this.addInitializeMethods(initializationMethod, (ImmutableList<ParameterSpec>)initializationParameters.values().asList());
    }

    private void addConfigureInitializationMethod() {
        MethodSpec.Builder method = this.configureInitializationMethodBuilder();
        ImmutableMap<ComponentRequirement, ParameterSpec> parameters = this.initializationParameters();
        this.implementInitializationMethod(method, parameters);
        this.componentImplementation.setConfigureInitializationMethod(ComponentImplementation.ConfigureInitializationMethod.create(method.build(), (ImmutableSet<ComponentRequirement>)parameters.keySet()));
    }

    private MethodSpec.Builder configureInitializationMethodBuilder() {
        String methodName = this.componentImplementation.getUniqueMethodName("configureInitialization");
        MethodSpec.Builder configureInitialization = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PROTECTED});
        if (this.overridesSuperclassConfigureInitialization(configureInitialization.build())) {
            configureInitialization.addAnnotation(Override.class);
        }
        return configureInitialization;
    }

    private boolean overridesSuperclassConfigureInitialization(MethodSpec method) {
        Optional<ComponentImplementation> currentSuperImplementation = this.componentImplementation.superclassImplementation();
        while (currentSuperImplementation.isPresent()) {
            Optional<MethodSpec> superConfigureInitializationMethod = currentSuperImplementation.get().configureInitializationMethod().map(m -> m.spec());
            if (superConfigureInitializationMethod.filter(superMethod -> this.haveSameSignature(method, (MethodSpec)superMethod)).isPresent()) {
                return true;
            }
            currentSuperImplementation = currentSuperImplementation.get().superclassImplementation();
        }
        return false;
    }

    private boolean haveSameSignature(MethodSpec a, MethodSpec b) {
        return a.name.equals(b.name) && this.types(a.parameters).equals(this.types(b.parameters));
    }

    private ImmutableList<TypeName> types(List<ParameterSpec> parameters) {
        return parameters.stream().map(parameter -> parameter.type).collect(DaggerStreams.toImmutableList());
    }

    private void addSuperConfigureInitializationCall(MethodSpec.Builder callingMethod, ImmutableMap<ComponentRequirement, ParameterSpec> parameters, ComponentImplementation.ConfigureInitializationMethod superConfigureInitializationMethod) {
        CodeBlock args = superConfigureInitializationMethod.parameters().stream().map(requirement -> parameters.containsKey(requirement) ? CodeBlock.of((String)"$N", (Object[])new Object[]{parameters.get(requirement)}) : CodeBlock.of((String)"null", (Object[])new Object[0])).collect(CodeBlocks.toParametersCodeBlock());
        String qualifier = this.haveSameSignature(callingMethod.build(), superConfigureInitializationMethod.spec()) ? "super." : "";
        callingMethod.addStatement(qualifier + "$N($L)", new Object[]{superConfigureInitializationMethod.spec(), args});
    }

    private void addInitializeMethods(MethodSpec.Builder callingMethod, ImmutableList<ParameterSpec> parameters) {
        CodeBlock args = CodeBlocks.parameterNames(parameters);
        ImmutableList<MethodSpec> methods = this.createPartitionedMethods("initialize", (Iterable<ParameterSpec>)this.makeFinal((Collection<ParameterSpec>)parameters), (List<CodeBlock>)this.componentImplementation.getInitializations(), methodName -> MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])));
        for (MethodSpec method : methods) {
            callingMethod.addStatement("$N($L)", new Object[]{method, args});
            this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.INITIALIZE_METHOD, method);
        }
    }

    private ImmutableList<MethodSpec> createPartitionedMethods(String methodName, Iterable<ParameterSpec> parameters, List<CodeBlock> statements, Function<String, MethodSpec.Builder> methodBuilderCreator) {
        return Lists.partition(statements, (int)100).stream().map(partition -> ((MethodSpec.Builder)methodBuilderCreator.apply(this.componentImplementation.getUniqueMethodName(methodName))).addParameters(parameters).addCode(CodeBlocks.concat(partition)).build()).collect(DaggerStreams.toImmutableList());
    }

    private final ImmutableList<ParameterSpec> makeFinal(Collection<ParameterSpec> parameters) {
        return parameters.stream().map(param -> param.toBuilder().addModifiers(new Modifier[]{Modifier.FINAL}).build()).collect(DaggerStreams.toImmutableList());
    }

    private final ImmutableMap<ComponentRequirement, ParameterSpec> initializationParameters() {
        Object parameters;
        Optional<ComponentCreatorImplementation> creatorImplementation = Optionals.firstPresent(this.componentImplementation.creatorImplementation(), this.componentImplementation.baseCreatorImplementation(), new Optional[0]);
        if (creatorImplementation.isPresent()) {
            parameters = Maps.toMap(creatorImplementation.get().providedRequirements(), ComponentRequirement::toParameterSpec);
        } else if (this.componentImplementation.isAbstract() && this.componentImplementation.isNested()) {
            parameters = ImmutableMap.of();
        } else if (this.graph.factoryMethod().isPresent()) {
            parameters = ComponentImplementationBuilder.getFactoryMethodParameters(this.graph);
        } else if (this.componentImplementation.isAbstract()) {
            parameters = ImmutableMap.of();
        } else {
            throw new AssertionError((Object)"Expected either a component creator or factory method but found neither.");
        }
        if (this.componentImplementation.isAbstract()) {
            parameters = Maps.filterKeys((Map)parameters, (Predicate)Predicates.in(this.configureInitializationRequirements()));
        }
        return this.renameParameters((Map<ComponentRequirement, ParameterSpec>)parameters);
    }

    private ImmutableSet<ComponentRequirement> configureInitializationRequirements() {
        ImmutableSet<ComponentRequirement> initializationParameters = this.componentImplementation.getComponentRequirementParameters();
        ImmutableSet superConfigureInitializationRequirements = this.componentImplementation.superConfigureInitializationMethod().map(ComponentImplementation.ConfigureInitializationMethod::parameters).orElse(ImmutableSet.of());
        return Sets.union(initializationParameters, (Set)superConfigureInitializationRequirements).immutableCopy();
    }

    private ImmutableMap<ComponentRequirement, ParameterSpec> renameParameters(Map<ComponentRequirement, ParameterSpec> parameters) {
        return ImmutableMap.copyOf((Map)Maps.transformEntries(parameters, (requirement, parameter) -> this.renameParameter((ParameterSpec)parameter, this.componentImplementation.getParameterName((ComponentRequirement)requirement, parameter.name))));
    }

    private ParameterSpec renameParameter(ParameterSpec parameter, String newName) {
        return ParameterSpec.builder((TypeName)parameter.type, (String)newName, (Modifier[])new Modifier[0]).addAnnotations((Iterable)parameter.annotations).addModifiers((Iterable)parameter.modifiers).build();
    }

    private static Map<ComponentRequirement, ParameterSpec> getFactoryMethodParameters(BindingGraph graph) {
        return Maps.transformValues(graph.factoryMethodParameters(), ParameterSpec::get);
    }

    static final class SubcomponentImplementationBuilder
    extends ComponentImplementationBuilder {
        final Optional<ComponentImplementationBuilder> parent;

        @Inject
        SubcomponentImplementationBuilder(@ParentComponent Optional<ComponentImplementationBuilder> parent) {
            this.parent = parent;
        }

        @Override
        protected void addCreatorClass(TypeSpec creator) {
            if (this.parent.isPresent()) {
                this.parent.get().componentImplementation.addType(ComponentImplementation.TypeSpecKind.SUBCOMPONENT, creator);
            } else {
                this.componentImplementation.addType(ComponentImplementation.TypeSpecKind.SUBCOMPONENT, creator);
            }
        }

        @Override
        protected void addFactoryMethods() {
            if (!this.componentImplementation.isAbstract()) {
                this.graph.factoryMethod().ifPresent(this::createSubcomponentFactoryMethod);
            }
        }

        private void createSubcomponentFactoryMethod(ExecutableElement factoryMethod) {
            com.google.common.base.Preconditions.checkState((boolean)this.parent.isPresent());
            Collection<ParameterSpec> params = ComponentImplementationBuilder.getFactoryMethodParameters(this.graph).values();
            MethodSpec.Builder method = MethodSpec.overriding((ExecutableElement)factoryMethod, (DeclaredType)this.parentType(), (Types)this.types);
            params.forEach(param -> method.addStatement("$T.checkNotNull($N)", new Object[]{Preconditions.class, param}));
            method.addStatement("return new $T($L)", new Object[]{this.componentImplementation.name(), CodeBlocks.parameterNames(params)});
            this.parent.get().componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.COMPONENT_METHOD, method.build());
        }

        private DeclaredType parentType() {
            return MoreTypes.asDeclared(this.parent.get().graph.componentTypeElement().asType());
        }

        @Override
        protected void addInterfaceMethods() {
            if (this.componentImplementation.superclassImplementation().isPresent()) {
                ComponentImplementation superclassImplementation = this.componentImplementation.superclassImplementation().get();
                for (ModifiableBindingMethods.ModifiableBindingMethod superclassModifiableBindingMethod : superclassImplementation.getModifiableBindingMethods()) {
                    this.bindingExpressions.modifiableBindingExpressions().reimplementedModifiableBindingMethod(superclassModifiableBindingMethod).ifPresent(this.componentImplementation::addImplementedModifiableBindingMethod);
                }
            } else {
                super.addInterfaceMethods();
            }
        }

        @Override
        protected Optional<CodeBlock> cancelParentStatement() {
            if (!this.shouldPropagateCancellationToParent()) {
                return Optional.empty();
            }
            return Optional.of(CodeBlock.builder().addStatement("$T.this.$N($N)", new Object[]{this.parent.get().componentImplementation.name(), ComponentImplementationBuilder.CANCELLATION_LISTENER_METHOD_NAME, ComponentImplementationBuilder.MAY_INTERRUPT_IF_RUNNING}).build());
        }

        private boolean shouldPropagateCancellationToParent() {
            return this.parent.isPresent() && this.parent.get().componentImplementation.componentDescriptor().cancellationPolicy().map(policy -> policy.fromSubcomponents().equals((Object)CancellationPolicy.Propagation.PROPAGATE)).orElse(false) != false;
        }
    }

    static final class RootComponentImplementationBuilder
    extends ComponentImplementationBuilder {
        @Inject
        RootComponentImplementationBuilder(ComponentImplementation componentImplementation) {
            com.google.common.base.Preconditions.checkArgument((!componentImplementation.superclassImplementation().isPresent() ? 1 : 0) != 0);
        }

        @Override
        protected void addCreatorClass(TypeSpec creator) {
            this.componentImplementation.addType(ComponentImplementation.TypeSpecKind.COMPONENT_CREATOR, creator);
        }

        @Override
        protected void addFactoryMethods() {
            MethodSpec creatorFactoryMethod = MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.creatorDescriptor().map(creatorDescriptor -> ClassName.get((TypeElement)creatorDescriptor.typeElement())).orElse(this.componentCreatorName())).addStatement("return new $T()", new Object[]{this.componentCreatorName()}).build();
            this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.BUILDER_METHOD, creatorFactoryMethod);
            if (this.canInstantiateAllRequirements()) {
                String buildMethodName = this.creatorDescriptor().isPresent() ? this.creatorDescriptor().get().factoryMethod().getSimpleName() : "build";
                this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.BUILDER_METHOD, MethodSpec.methodBuilder((String)"create").returns((TypeName)ClassName.get((TypeElement)this.graph.componentTypeElement())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return new Builder().$L()", new Object[]{buildMethodName}).build());
            }
        }

        private Optional<ComponentCreatorDescriptor> creatorDescriptor() {
            return this.graph.componentDescriptor().creatorDescriptor();
        }

        private boolean canInstantiateAllRequirements() {
            return !Iterables.any(this.graph.componentRequirements(), dependency -> dependency.requiresAPassedInstance(this.elements, this.types));
        }

        private ClassName componentCreatorName() {
            return this.componentImplementation.creatorImplementation().get().name();
        }
    }
}

