/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import dagger.Component;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentCreatorDescriptor;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentHierarchyValidator;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DiagnosticFormatting;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.ValidationType;
import dagger.model.Scope;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class ComponentDescriptorValidator {
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final CompilerOptions compilerOptions;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final ComponentHierarchyValidator componentHierarchyValidator;

    @Inject
    ComponentDescriptorValidator(DaggerElements elements, DaggerTypes types, CompilerOptions compilerOptions, MethodSignatureFormatter methodSignatureFormatter, ComponentHierarchyValidator componentHierarchyValidator) {
        this.elements = elements;
        this.types = types;
        this.compilerOptions = compilerOptions;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.componentHierarchyValidator = componentHierarchyValidator;
    }

    ValidationReport<TypeElement> validate(ComponentDescriptor component) {
        ComponentValidation validation = new ComponentValidation(component);
        validation.visitComponent(component);
        validation.report(component).addSubreport(this.componentHierarchyValidator.validate(component));
        return validation.buildReport();
    }

    private final class ComponentValidation {
        final ComponentDescriptor rootComponent;
        final Map<ComponentDescriptor, ValidationReport.Builder<TypeElement>> reports = new LinkedHashMap<ComponentDescriptor, ValidationReport.Builder<TypeElement>>();

        ComponentValidation(ComponentDescriptor rootComponent) {
            this.rootComponent = (ComponentDescriptor)Preconditions.checkNotNull((Object)rootComponent);
        }

        ValidationReport<TypeElement> buildReport() {
            ValidationReport.Builder<TypeElement> report = ValidationReport.about(this.rootComponent.typeElement());
            this.reports.values().forEach(subreport -> report.addSubreport(subreport.build()));
            return report.build();
        }

        private ValidationReport.Builder<TypeElement> report(ComponentDescriptor component) {
            return Util.reentrantComputeIfAbsent(this.reports, component, descriptor -> ValidationReport.about(descriptor.typeElement()));
        }

        void visitComponent(ComponentDescriptor component) {
            this.validateDependencyScopes(component);
            this.validateComponentDependencyHierarchy(component);
            this.validateModules(component);
            this.validateCreators(component);
            component.childComponents().forEach(this::visitComponent);
        }

        private void validateComponentDependencyHierarchy(ComponentDescriptor component) {
            this.validateComponentDependencyHierarchy(component, component.typeElement(), new ArrayDeque<TypeElement>());
        }

        private void validateComponentDependencyHierarchy(ComponentDescriptor component, TypeElement dependency, Deque<TypeElement> dependencyStack) {
            if (dependencyStack.contains(dependency)) {
                StringBuilder message = new StringBuilder();
                message.append(component.typeElement().getQualifiedName());
                message.append(" contains a cycle in its component dependencies:\n");
                dependencyStack.push(dependency);
                this.appendIndentedComponentsList(message, dependencyStack);
                dependencyStack.pop();
                this.report(component).addItem(message.toString(), ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), component.typeElement(), ConfigurationAnnotations.getComponentAnnotation(component.typeElement()).get());
            } else {
                Optional<AnnotationMirror> componentAnnotation = ConfigurationAnnotations.getComponentAnnotation(dependency);
                if (componentAnnotation.isPresent()) {
                    dependencyStack.push(dependency);
                    ImmutableSet<TypeElement> dependencies = MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies(componentAnnotation.get()));
                    for (TypeElement nextDependency : dependencies) {
                        this.validateComponentDependencyHierarchy(component, nextDependency, dependencyStack);
                    }
                    dependencyStack.pop();
                }
            }
        }

        private void validateDependencyScopes(ComponentDescriptor component) {
            ImmutableSet<Scope> scopes = component.scopes();
            ImmutableSet<TypeElement> scopedDependencies = this.scopedTypesIn((Set)component.dependencies().stream().map(ComponentRequirement::typeElement).collect(DaggerStreams.toImmutableSet()));
            if (!scopes.isEmpty()) {
                Scope singletonScope = Scopes.singletonScope(ComponentDescriptorValidator.this.elements);
                if (ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent() && scopes.contains((Object)singletonScope)) {
                    if (!scopedDependencies.isEmpty()) {
                        StringBuilder message = new StringBuilder("This @Singleton component cannot depend on scoped components:\n");
                        this.appendIndentedComponentsList(message, (Iterable<TypeElement>)scopedDependencies);
                        this.report(component).addItem(message.toString(), ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), component.typeElement(), component.annotation());
                    }
                } else if (scopedDependencies.size() > 1) {
                    StringBuilder message = new StringBuilder();
                    for (Scope scope : scopes) {
                        message.append(Scopes.getReadableSource(scope)).append(' ');
                    }
                    message.append(component.typeElement().getQualifiedName()).append(" depends on more than one scoped component:\n");
                    this.appendIndentedComponentsList(message, (Iterable<TypeElement>)scopedDependencies);
                    this.report(component).addError(message.toString(), component.typeElement(), component.annotation());
                } else if (!ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().equals((Object)ValidationType.NONE)) {
                    this.validateDependencyScopeHierarchy(component, component.typeElement(), new ArrayDeque<ImmutableSet<Scope>>(), new ArrayDeque<TypeElement>());
                }
            } else if (!scopedDependencies.isEmpty()) {
                StringBuilder message = new StringBuilder(component.typeElement().getQualifiedName()).append(" (unscoped) cannot depend on scoped components:\n");
                this.appendIndentedComponentsList(message, (Iterable<TypeElement>)scopedDependencies);
                this.report(component).addError(message.toString(), component.typeElement(), component.annotation());
            }
        }

        private void validateModules(ComponentDescriptor component) {
            block0: for (ModuleDescriptor module : component.modules()) {
                if (!module.moduleElement().getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                for (ContributionBinding binding : module.bindings()) {
                    if (!binding.requiresModuleInstance()) continue;
                    this.report(component).addError(this.abstractModuleHasInstanceBindingMethodsError(module));
                    continue block0;
                }
            }
        }

        private String abstractModuleHasInstanceBindingMethodsError(ModuleDescriptor module) {
            String methodAnnotations;
            switch (module.kind()) {
                case MODULE: {
                    methodAnnotations = "@Provides";
                    break;
                }
                case PRODUCER_MODULE: {
                    methodAnnotations = "@Provides or @Produces";
                    break;
                }
                default: {
                    throw new AssertionError((Object)module.kind());
                }
            }
            return String.format("%s is abstract and has instance %s methods. Consider making the methods static or including a non-abstract subclass of the module instead.", module.moduleElement(), methodAnnotations);
        }

        private void validateCreators(ComponentDescriptor component) {
            Set mustBePassed;
            Sets.SetView missingRequirements;
            ImmutableSet<ComponentRequirement> componentModuleAndDependencyRequirements;
            if (!component.creatorDescriptor().isPresent()) {
                return;
            }
            ComponentCreatorDescriptor creator = component.creatorDescriptor().get();
            ErrorMessages.ComponentCreatorMessages msgs = ErrorMessages.creatorMessagesFor(component.kind());
            ImmutableSet<ComponentRequirement> creatorModuleAndDependencyRequirements = creator.moduleAndDependencyRequirements();
            Sets.SetView inapplicableRequirementsOnCreator = Sets.difference(creatorModuleAndDependencyRequirements, componentModuleAndDependencyRequirements = component.dependenciesAndConcreteModules());
            if (!inapplicableRequirementsOnCreator.isEmpty()) {
                Collection excessElements = Multimaps.filterKeys(creator.requirementElements(), (Predicate)Predicates.in((Collection)inapplicableRequirementsOnCreator)).values();
                Optional<DeclaredType> container = Optional.of(MoreTypes.asDeclared(creator.typeElement().asType()));
                String formatted = excessElements.stream().map(method -> ComponentDescriptorValidator.this.methodSignatureFormatter.format((ExecutableElement)method, container)).collect(Collectors.joining(", ", "[", "]"));
                this.report(component).addError(String.format(msgs.extraSetters(), formatted), creator.typeElement());
            }
            if (!(missingRequirements = Sets.difference((Set)(mustBePassed = Sets.filter(componentModuleAndDependencyRequirements, input -> input.nullPolicy(ComponentDescriptorValidator.this.elements, ComponentDescriptorValidator.this.types).equals((Object)ComponentRequirement.NullPolicy.THROW))), creatorModuleAndDependencyRequirements)).isEmpty()) {
                this.report(component).addError(String.format(msgs.missingSetters(), missingRequirements.stream().map(ComponentRequirement::type).collect(Collectors.toList())), creator.typeElement());
            }
            ImmutableSetMultimap<Equivalence.Wrapper, ExecutableElement> declaredRequirementsByType = Multimaps.filterKeys(creator.requirementElements(), (Predicate)Predicates.in(creatorModuleAndDependencyRequirements)).entries().stream().collect(DaggerStreams.toImmutableSetMultimap(entry -> ((ComponentRequirement)entry.getKey()).wrappedType(), Map.Entry::getValue));
            declaredRequirementsByType.asMap().forEach((typeWrapper, elementsForType) -> {
                if (elementsForType.size() > 1) {
                    TypeMirror type = (TypeMirror)typeWrapper.get();
                    this.report(component).addError(String.format(msgs.manyMethodsForType(), type, elementsForType), creator.typeElement());
                }
            });
        }

        private void validateDependencyScopeHierarchy(ComponentDescriptor component, TypeElement dependency, Deque<ImmutableSet<Scope>> scopeStack, Deque<TypeElement> scopedDependencyStack) {
            ImmutableSet<Scope> scopes = Scopes.scopesOf(dependency);
            if (this.stackOverlaps(scopeStack, scopes)) {
                scopedDependencyStack.push(dependency);
                StringBuilder message = new StringBuilder();
                message.append(component.typeElement().getQualifiedName());
                message.append(" depends on scoped components in a non-hierarchical scope ordering:\n");
                this.appendIndentedComponentsList(message, scopedDependencyStack);
                if (ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent()) {
                    this.report(component).addItem(message.toString(), ComponentDescriptorValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), component.typeElement(), ConfigurationAnnotations.getComponentAnnotation(component.typeElement()).get());
                }
                scopedDependencyStack.pop();
            } else {
                DaggerElements.getAnnotationMirror(dependency, Component.class).ifPresent(componentAnnotation -> {
                    ImmutableSet<TypeElement> scopedDependencies = this.scopedTypesIn((Set<TypeElement>)MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies(componentAnnotation)));
                    if (scopedDependencies.size() == 1) {
                        scopeStack.push(scopes);
                        scopedDependencyStack.push(dependency);
                        this.validateDependencyScopeHierarchy(component, (TypeElement)Iterables.getOnlyElement(scopedDependencies), scopeStack, scopedDependencyStack);
                        scopedDependencyStack.pop();
                        scopeStack.pop();
                    }
                });
            }
        }

        private <T> boolean stackOverlaps(Deque<ImmutableSet<T>> stack, ImmutableSet<T> set) {
            for (ImmutableSet<T> entry : stack) {
                if (Sets.intersection(entry, set).isEmpty()) continue;
                return true;
            }
            return false;
        }

        private void appendIndentedComponentsList(StringBuilder message, Iterable<TypeElement> types) {
            for (TypeElement scopedComponent : types) {
                message.append("    ");
                for (Scope scope : Scopes.scopesOf(scopedComponent)) {
                    message.append(Scopes.getReadableSource(scope)).append(' ');
                }
                message.append(DiagnosticFormatting.stripCommonTypePrefixes(scopedComponent.getQualifiedName().toString())).append('\n');
            }
        }

        private ImmutableSet<TypeElement> scopedTypesIn(Set<TypeElement> types) {
            return types.stream().filter(type -> !Scopes.scopesOf(type).isEmpty()).collect(DaggerStreams.toImmutableSet());
        }
    }
}

