/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.FactoryGenerator;
import dagger.internal.codegen.HjarSourceFileGenerator;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MembersInjectorGenerator;
import dagger.internal.codegen.ProducerFactoryGenerator;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SourceFileGenerator;

@Module(includes={ProvisionModule.class, ProductionModule.class, MembersInjectionModule.class, ComponentModule.class})
interface SourceFileGeneratorsModule {

    @Module
    public static class ComponentModule
    extends GeneratorModule<BindingGraph, ComponentGenerator> {
    }

    @Module
    public static class MembersInjectionModule
    extends GeneratorModule<MembersInjectionBinding, MembersInjectorGenerator> {
    }

    @Module
    public static class ProductionModule
    extends GeneratorModule<ProductionBinding, ProducerFactoryGenerator> {
    }

    @Module
    public static class ProvisionModule
    extends GeneratorModule<ProvisionBinding, FactoryGenerator> {
    }

    @Module
    public static abstract class GeneratorModule<T, G extends SourceFileGenerator<T>> {
        @Provides
        SourceFileGenerator<T> generator(G generator, CompilerOptions compilerOptions) {
            return compilerOptions.headerCompilation() ? HjarSourceFileGenerator.wrap(generator) : generator;
        }
    }
}

