/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Verify;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.Keys;
import dagger.internal.codegen.RequestKinds;
import dagger.model.Binding;
import dagger.model.BindingGraph;
import dagger.model.Key;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import javax.inject.Inject;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;

final class MissingBindingValidator
implements BindingGraphPlugin {
    private final DaggerTypes types;
    private final InjectBindingRegistry injectBindingRegistry;

    @Inject
    MissingBindingValidator(DaggerTypes types, InjectBindingRegistry injectBindingRegistry) {
        this.types = types;
        this.injectBindingRegistry = injectBindingRegistry;
    }

    public String pluginName() {
        return "Dagger/MissingBinding";
    }

    public void visitGraph(BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        if (graph.isModuleBindingGraph() || graph.isPartialBindingGraph()) {
            return;
        }
        graph.missingBindings().forEach(missingBinding -> this.reportMissingBinding((BindingGraph.MissingBinding)missingBinding, graph, diagnosticReporter));
    }

    private void reportMissingBinding(BindingGraph.MissingBinding missingBinding, BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, (BindingGraph.MaybeBinding)missingBinding, this.missingBindingErrorMessage(missingBinding, graph));
    }

    private String missingBindingErrorMessage(BindingGraph.MissingBinding missingBinding, BindingGraph graph) {
        Key key = missingBinding.key();
        StringBuilder errorMessage = new StringBuilder();
        Verify.verify((!key.type().getKind().equals((Object)TypeKind.WILDCARD) ? 1 : 0) != 0, (String)"unexpected wildcard request: %s", (Object)key);
        errorMessage.append(key).append(" cannot be provided without ");
        if (Keys.isValidImplicitProvisionKey(key, this.types)) {
            errorMessage.append("an @Inject constructor or ");
        }
        errorMessage.append("an @Provides-");
        if (this.allIncomingDependenciesCanUseProduction(missingBinding, graph)) {
            errorMessage.append(" or @Produces-");
        }
        errorMessage.append("annotated method.");
        if (Keys.isValidMembersInjectionKey(key) && this.typeHasInjectionSites(key)) {
            errorMessage.append(" This type supports members injection but cannot be implicitly provided.");
        }
        graph.bindings(key).stream().map(binding -> binding.componentPath().currentComponent()).distinct().forEach(component -> errorMessage.append("\nA binding with matching key exists in component: ").append(component.getQualifiedName()));
        return errorMessage.toString();
    }

    private boolean allIncomingDependenciesCanUseProduction(BindingGraph.MissingBinding missingBinding, BindingGraph graph) {
        return graph.network().inEdges((Object)missingBinding).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).allMatch(edge -> this.dependencyCanBeProduction((BindingGraph.DependencyEdge)edge, graph));
    }

    private boolean dependencyCanBeProduction(BindingGraph.DependencyEdge edge, BindingGraph graph) {
        BindingGraph.Node source = (BindingGraph.Node)graph.network().incidentNodes((Object)edge).source();
        if (source instanceof BindingGraph.ComponentNode) {
            return RequestKinds.entryPointCanUseProduction(edge.dependencyRequest().kind());
        }
        if (source instanceof Binding) {
            return ((Binding)source).isProduction();
        }
        throw new IllegalArgumentException("expected a dagger.model.Binding or ComponentNode: " + source);
    }

    private boolean typeHasInjectionSites(Key key) {
        return this.injectBindingRegistry.getOrFindMembersInjectionBinding(key).map(binding -> !binding.injectionSites().isEmpty()).orElse(false);
    }
}

