/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.BindingMethodImplementation;
import dagger.internal.codegen.BindingVariableNamer;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MethodBindingExpression;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.RequestKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class PrivateMethodBindingExpression
extends MethodBindingExpression {
    private final ContributionBinding binding;
    private final RequestKind requestKind;
    private final BindingMethodImplementation methodImplementation;
    private final GeneratedComponentModel generatedComponentModel;
    private String methodName;

    PrivateMethodBindingExpression(ResolvedBindings resolvedBindings, RequestKind requestKind, BindingMethodImplementation methodImplementation, GeneratedComponentModel generatedComponentModel) {
        super(methodImplementation, generatedComponentModel);
        this.binding = resolvedBindings.contributionBinding();
        this.requestKind = (RequestKind)Preconditions.checkNotNull((Object)requestKind);
        this.methodImplementation = (BindingMethodImplementation)Preconditions.checkNotNull((Object)methodImplementation);
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
    }

    @Override
    protected void addMethod() {
        if (this.methodName == null) {
            this.methodName = this.chooseMethodName();
            this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.PRIVATE_METHOD, MethodSpec.methodBuilder((String)this.methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(TypeName.get((TypeMirror)this.methodImplementation.returnType())).addCode(this.methodImplementation.body()).build());
        }
    }

    @Override
    protected String methodName() {
        Preconditions.checkState((this.methodName != null ? 1 : 0) != 0, (Object)"addMethod() must be called before methodName()");
        return this.methodName;
    }

    private String chooseMethodName() {
        return this.generatedComponentModel.getUniqueMethodName("get" + this.bindingName() + this.dependencyKindName());
    }

    private String bindingName() {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, BindingVariableNamer.name(this.binding));
    }

    private String dependencyKindName() {
        return this.requestKind.equals((Object)RequestKind.INSTANCE) ? "" : CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.requestKind.name());
    }
}

