/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.Keys;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.RequestKinds;
import dagger.internal.codegen.Scopes;
import dagger.model.BindingGraph;
import dagger.model.Key;
import dagger.model.Scope;
import dagger.releasablereferences.CanReleaseReferences;
import dagger.releasablereferences.ForReleasableReferences;
import dagger.releasablereferences.ReleasableReferenceManager;
import dagger.releasablereferences.TypedReleasableReferenceManager;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

final class MissingBindingValidation
implements BindingGraphPlugin {
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final InjectBindingRegistry injectBindingRegistry;

    @Inject
    MissingBindingValidation(DaggerTypes types, DaggerElements elements, InjectBindingRegistry injectBindingRegistry) {
        this.types = types;
        this.injectBindingRegistry = injectBindingRegistry;
        this.elements = elements;
    }

    public String pluginName() {
        return "Dagger/MissingBinding";
    }

    public void visitGraph(BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        graph.missingBindingNodes().stream().flatMap(node -> graph.inEdges(node).stream()).flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).forEach(edge -> this.reportMissingBinding((BindingGraph.DependencyEdge)edge, graph, diagnosticReporter));
    }

    private void reportMissingBinding(BindingGraph.DependencyEdge edge, BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        diagnosticReporter.reportDependency(Diagnostic.Kind.ERROR, edge, this.missingReleasableReferenceManagerBindingErrorMessage(edge, graph).orElseGet(() -> this.missingBindingErrorMessage(edge, graph)));
    }

    private String missingBindingErrorMessage(BindingGraph.DependencyEdge edge, BindingGraph graph) {
        Key key = edge.dependencyRequest().key();
        StringBuilder errorMessage = new StringBuilder();
        if (key.type().getKind().equals((Object)TypeKind.WILDCARD)) {
            errorMessage.append("Dagger does not support injecting Provider<T>, Lazy<T>, Producer<T>, ").append("or Produced<T> when T is a wildcard type such as ").append(key);
        } else {
            errorMessage.append(key).append(" cannot be provided without ");
            if (Keys.isValidImplicitProvisionKey(key, this.types)) {
                errorMessage.append("an @Inject constructor or ");
            }
            errorMessage.append("an @Provides-");
            if (this.dependencyCanBeProduction(edge, graph)) {
                errorMessage.append(" or @Produces-");
            }
            errorMessage.append("annotated method.");
        }
        if (Keys.isValidMembersInjectionKey(key) && this.typeHasInjectionSites(key)) {
            errorMessage.append(" This type supports members injection but cannot be implicitly provided.");
        }
        graph.bindingNodes(key).stream().map(bindingNode -> bindingNode.componentPath().currentComponent()).distinct().forEach(component -> errorMessage.append("\nA binding with matching key exists in component: ").append(component.getQualifiedName()));
        return errorMessage.toString();
    }

    private boolean dependencyCanBeProduction(BindingGraph.DependencyEdge edge, BindingGraph graph) {
        BindingGraph.Node source = (BindingGraph.Node)graph.incidentNodes((Object)edge).source();
        if (source instanceof BindingGraph.ComponentNode) {
            return RequestKinds.entryPointCanUseProduction(edge.dependencyRequest().kind());
        }
        if (source instanceof BindingGraph.BindingNode) {
            return ((BindingGraph.BindingNode)source).binding().isProduction();
        }
        throw new IllegalArgumentException("expected a BindingNode or ComponentNode: " + source);
    }

    private boolean typeHasInjectionSites(Key key) {
        return this.injectBindingRegistry.getOrFindMembersInjectionBinding(key).map(binding -> !binding.injectionSites().isEmpty()).orElse(false);
    }

    private Optional<String> missingReleasableReferenceManagerBindingErrorMessage(BindingGraph.DependencyEdge edge, BindingGraph graph) {
        Optional<Object> metadataType;
        Key key = edge.dependencyRequest().key();
        if (!(key.qualifier().isPresent() && MoreTypes.isTypeOf(ForReleasableReferences.class, ((AnnotationMirror)key.qualifier().get()).getAnnotationType()) && MoreTypes.isType(key.type()))) {
            return Optional.empty();
        }
        if (MoreTypes.isTypeOf(ReleasableReferenceManager.class, key.type())) {
            metadataType = Optional.empty();
        } else if (MoreTypes.isTypeOf(TypedReleasableReferenceManager.class, key.type())) {
            List<? extends TypeMirror> typeArguments = MoreTypes.asDeclared(key.type()).getTypeArguments();
            if (typeArguments.size() != 1 || !typeArguments.get(0).getKind().equals((Object)TypeKind.DECLARED)) {
                return Optional.empty();
            }
            metadataType = Optional.of(MoreTypes.asDeclared(typeArguments.get(0)));
        } else {
            return Optional.empty();
        }
        Scope scope = Scopes.scope(MoreTypes.asTypeElement(MoreAnnotationMirrors.getTypeValue((AnnotationMirror)key.qualifier().get(), "value")));
        if (this.releasableReferencesScopes(graph).noneMatch(Predicate.isEqual(scope))) {
            return Optional.of(String.format("There is no binding for %s because no component in %s's component hierarchy is annotated with %s. The available reference-releasing scopes are %s.", key, graph.rootComponentNode().toString(), Scopes.getReadableSource(scope), this.releasableReferencesScopes(graph).map(Scopes::getReadableSource).collect(Collectors.toList())));
        }
        if (metadataType.isPresent()) {
            TypeElement metadataTypeElement = MoreTypes.asTypeElement((TypeMirror)metadataType.get());
            if (!DaggerElements.isAnnotationPresent(scope.scopeAnnotationElement(), (TypeMirror)metadataType.get())) {
                return Optional.of(MissingBindingValidation.notAnnotated(key, scope.scopeAnnotationElement(), metadataTypeElement));
            }
            if (!MoreElements.isAnnotationPresent(metadataTypeElement, CanReleaseReferences.class)) {
                return Optional.of(MissingBindingValidation.notAnnotated(key, metadataTypeElement, this.elements.getTypeElement(CanReleaseReferences.class)));
            }
        }
        return Optional.empty();
    }

    private static String notAnnotated(Key key, TypeElement type, TypeElement annotation) {
        return String.format("There is no binding for %s because %s is not annotated with @%s.", key, type.getQualifiedName(), annotation);
    }

    private Stream<Scope> releasableReferencesScopes(BindingGraph graph) {
        return graph.componentNodes().stream().flatMap(node -> node.scopes().stream()).filter(Scope::canReleaseReferences);
    }
}

