/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.TypeSpecs;
import dagger.internal.codegen.UniqueNameSet;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class GeneratedComponentModel {
    private final ClassName name;
    private final TypeSpec.Builder component;
    private final UniqueNameSet componentFieldNames = new UniqueNameSet();
    private final UniqueNameSet componentMethodNames = new UniqueNameSet();
    private final List<CodeBlock> initializations = new ArrayList<CodeBlock>();
    private final ListMultimap<FieldSpecKind, FieldSpec> fieldSpecsMap = MultimapBuilder.enumKeys(FieldSpecKind.class).arrayListValues().build();
    private final ListMultimap<MethodSpecKind, MethodSpec> methodSpecsMap = MultimapBuilder.enumKeys(MethodSpecKind.class).arrayListValues().build();
    private final ListMultimap<TypeSpecKind, TypeSpec> typeSpecsMap = MultimapBuilder.enumKeys(TypeSpecKind.class).arrayListValues().build();
    private final List<Supplier<TypeSpec>> switchingProviderSupplier = new ArrayList<Supplier<TypeSpec>>();

    private GeneratedComponentModel(ClassName name, Modifier ... modifiers) {
        this.name = name;
        this.component = TypeSpec.classBuilder((ClassName)name).addModifiers(modifiers);
    }

    static GeneratedComponentModel forComponent(ClassName name) {
        return new GeneratedComponentModel(name, Modifier.PUBLIC, Modifier.FINAL);
    }

    static GeneratedComponentModel forSubcomponent(ClassName name) {
        return new GeneratedComponentModel(name, Modifier.PRIVATE, Modifier.FINAL);
    }

    ClassName name() {
        return this.name;
    }

    boolean isTypeAccessible(TypeMirror type) {
        return Accessibility.isTypeAccessibleFrom(type, this.name.packageName());
    }

    void addSupertype(TypeElement supertype) {
        TypeSpecs.addSupertype(this.component, supertype);
    }

    void addField(FieldSpecKind fieldKind, FieldSpec fieldSpec) {
        this.fieldSpecsMap.put((Object)fieldKind, (Object)fieldSpec);
    }

    void addFields(FieldSpecKind fieldKind, Iterable<FieldSpec> fieldSpecs) {
        this.fieldSpecsMap.putAll((Object)fieldKind, fieldSpecs);
    }

    void addMethod(MethodSpecKind methodKind, MethodSpec methodSpec) {
        this.methodSpecsMap.put((Object)methodKind, (Object)methodSpec);
    }

    void addMethods(MethodSpecKind methodKind, Iterable<MethodSpec> methodSpecs) {
        this.methodSpecsMap.putAll((Object)methodKind, methodSpecs);
    }

    void addType(TypeSpecKind typeKind, TypeSpec typeSpec) {
        this.typeSpecsMap.put((Object)typeKind, (Object)typeSpec);
    }

    void addTypes(TypeSpecKind typeKind, Iterable<TypeSpec> typeSpecs) {
        this.typeSpecsMap.putAll((Object)typeKind, typeSpecs);
    }

    void addSwitchingProvider(Supplier<TypeSpec> typeSpecSupplier) {
        this.switchingProviderSupplier.add(typeSpecSupplier);
    }

    void addInitialization(CodeBlock codeBlock) {
        this.initializations.add(codeBlock);
    }

    String getUniqueFieldName(String name) {
        return this.componentFieldNames.getUniqueName(name);
    }

    String getUniqueMethodName(String name) {
        return this.componentMethodNames.getUniqueName(name);
    }

    void claimMethodName(Name name) {
        this.componentMethodNames.claim(name);
    }

    ImmutableList<CodeBlock> getInitializations() {
        return ImmutableList.copyOf(this.initializations);
    }

    TypeSpec.Builder generate() {
        this.fieldSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addFields(arg_0));
        this.methodSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addMethods(arg_0));
        this.typeSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addTypes(arg_0));
        this.switchingProviderSupplier.stream().map(Supplier::get).forEach(arg_0 -> ((TypeSpec.Builder)this.component).addType(arg_0));
        return this.component;
    }

    static enum TypeSpecKind {
        PRESENT_FACTORY,
        COMPONENT_BUILDER,
        COMPONENT_PROVISION_FACTORY,
        SUBCOMPONENT;

    }

    static enum MethodSpecKind {
        CONSTRUCTOR,
        BUILDER_METHOD,
        PRIVATE_METHOD,
        INITIALIZE_METHOD,
        COMPONENT_METHOD,
        MEMBERS_INJECTION_METHOD,
        ABSENT_OPTIONAL_METHOD;

    }

    static enum FieldSpecKind {
        PRIVATE_METHOD_SCOPED_FIELD,
        COMPONENT_REQUIREMENT_FIELD,
        FRAMEWORK_FIELD,
        REFERENCE_RELEASING_MANAGER_FIELD,
        ABSENT_OPTIONAL_FIELD;

    }
}

