/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.Component;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentTreeTraverser;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequestFormatter;
import dagger.internal.codegen.DiagnosticFormatting;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.OptionalType;
import dagger.internal.codegen.RequestKinds;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.ValidationType;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.model.Scope;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class BindingGraphValidator {
    private final Elements elements;
    private final DaggerTypes types;
    private final CompilerOptions compilerOptions;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final DependencyRequestFormatter dependencyRequestFormatter;
    private final KeyFactory keyFactory;

    @Inject
    BindingGraphValidator(Elements elements, DaggerTypes types, CompilerOptions compilerOptions, MethodSignatureFormatter methodSignatureFormatter, DependencyRequestFormatter dependencyRequestFormatter, KeyFactory keyFactory) {
        this.elements = elements;
        this.types = types;
        this.compilerOptions = compilerOptions;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.dependencyRequestFormatter = dependencyRequestFormatter;
        this.keyFactory = keyFactory;
    }

    ValidationReport<TypeElement> validate(BindingGraph graph) {
        ComponentValidation validation = new ComponentValidation(graph);
        validation.traverseComponents();
        return validation.buildReport();
    }

    private void appendIndentedComponentsList(StringBuilder message, Iterable<TypeElement> types) {
        for (TypeElement scopedComponent : types) {
            message.append("    ");
            for (Scope scope : Scopes.scopesOf(scopedComponent)) {
                message.append(Scopes.getReadableSource(scope)).append(' ');
            }
            message.append(DiagnosticFormatting.stripCommonTypePrefixes(scopedComponent.getQualifiedName().toString())).append('\n');
        }
    }

    private ImmutableSet<TypeElement> scopedTypesIn(Set<TypeElement> types) {
        return types.stream().filter(type -> !Scopes.scopesOf(type).isEmpty()).collect(DaggerStreams.toImmutableSet());
    }

    private final class ComponentValidation
    extends ComponentTreeTraverser {
        final BindingGraph rootGraph;
        final Map<ComponentDescriptor, ValidationReport.Builder<TypeElement>> reports;
        private final SetMultimap<ComponentDescriptor, ContributionBinding> incompatiblyScopedBindings;

        ComponentValidation(BindingGraph rootGraph) {
            super(rootGraph);
            this.reports = new LinkedHashMap<ComponentDescriptor, ValidationReport.Builder<TypeElement>>();
            this.incompatiblyScopedBindings = LinkedHashMultimap.create();
            this.rootGraph = rootGraph;
        }

        @Override
        protected ComponentTreeTraverser.BindingGraphTraverser bindingGraphTraverser(ComponentTreeTraverser.ComponentTreePath componentPath, ComponentDescriptor.ComponentMethodDescriptor entryPointMethod) {
            return new BindingGraphValidation(componentPath, entryPointMethod);
        }

        ValidationReport<TypeElement> buildReport() {
            ValidationReport.Builder<TypeElement> report = ValidationReport.about(this.rootGraph.componentType());
            this.reports.values().forEach(subreport -> report.addSubreport(subreport.build()));
            return report.build();
        }

        private ValidationReport.Builder<TypeElement> report(BindingGraph graph) {
            return Util.reentrantComputeIfAbsent(this.reports, graph.componentDescriptor(), descriptor -> ValidationReport.about(descriptor.componentDefinitionType()));
        }

        @Override
        protected void visitComponent(BindingGraph graph) {
            this.validateDependencyScopes(graph);
            this.validateComponentDependencyHierarchy(graph);
            this.validateModules(graph);
            this.validateBuilders(graph);
            super.visitComponent(graph);
            this.checkScopedBindings(graph);
        }

        @Override
        protected void visitSubcomponentFactoryMethod(BindingGraph graph, BindingGraph parent, ExecutableElement factoryMethod) {
            Set missingModules = graph.componentRequirements().stream().filter(componentRequirement -> componentRequirement.kind().equals((Object)ComponentRequirement.Kind.MODULE)).map(ComponentRequirement::typeElement).filter(moduleType -> !this.subgraphFactoryMethodParameters(parent, factoryMethod).contains(moduleType)).filter(moduleType -> !Util.componentCanMakeNewInstances(moduleType)).collect(Collectors.toSet());
            if (!missingModules.isEmpty()) {
                this.report(parent).addError(String.format("%s requires modules which have no visible default constructors. Add the following modules as parameters to this method: %s", graph.componentType().getQualifiedName(), missingModules.stream().map(Object::toString).collect(Collectors.joining(", "))), factoryMethod);
            }
        }

        private ImmutableSet<TypeElement> subgraphFactoryMethodParameters(BindingGraph parent, ExecutableElement childFactoryMethod) {
            DeclaredType componentType = MoreTypes.asDeclared(parent.componentType().asType());
            ExecutableType factoryMethodType = MoreTypes.asExecutable(BindingGraphValidator.this.types.asMemberOf(componentType, childFactoryMethod));
            return MoreTypes.asTypeElements(factoryMethodType.getParameterTypes());
        }

        private void validateComponentDependencyHierarchy(BindingGraph graph) {
            this.validateComponentDependencyHierarchy(graph, graph.componentType(), new ArrayDeque<TypeElement>());
        }

        private void validateComponentDependencyHierarchy(BindingGraph graph, TypeElement dependency, Deque<TypeElement> dependencyStack) {
            if (dependencyStack.contains(dependency)) {
                StringBuilder message = new StringBuilder();
                message.append(graph.componentType().getQualifiedName());
                message.append(" contains a cycle in its component dependencies:\n");
                dependencyStack.push(dependency);
                BindingGraphValidator.this.appendIndentedComponentsList(message, dependencyStack);
                dependencyStack.pop();
                this.report(graph).addItem(message.toString(), BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), graph.componentType(), ConfigurationAnnotations.getComponentAnnotation(graph.componentType()).get());
            } else {
                Optional<AnnotationMirror> componentAnnotation = ConfigurationAnnotations.getComponentAnnotation(dependency);
                if (componentAnnotation.isPresent()) {
                    dependencyStack.push(dependency);
                    ImmutableSet<TypeElement> dependencies = MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies(componentAnnotation.get()));
                    for (TypeElement nextDependency : dependencies) {
                        this.validateComponentDependencyHierarchy(graph, nextDependency, dependencyStack);
                    }
                    dependencyStack.pop();
                }
            }
        }

        private void validateDependencyScopes(BindingGraph graph) {
            ComponentDescriptor descriptor = graph.componentDescriptor();
            ImmutableSet<Scope> scopes = descriptor.scopes();
            ImmutableSet scopedDependencies = BindingGraphValidator.this.scopedTypesIn((Set)descriptor.dependencies().stream().map(ComponentRequirement::typeElement).collect(DaggerStreams.toImmutableSet()));
            if (!scopes.isEmpty()) {
                Scope singletonScope = Scopes.singletonScope(BindingGraphValidator.this.elements);
                if (BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent() && scopes.contains((Object)singletonScope)) {
                    if (!scopedDependencies.isEmpty()) {
                        StringBuilder message = new StringBuilder("This @Singleton component cannot depend on scoped components:\n");
                        BindingGraphValidator.this.appendIndentedComponentsList(message, (Iterable)scopedDependencies);
                        this.report(graph).addItem(message.toString(), BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), descriptor.componentDefinitionType(), descriptor.componentAnnotation());
                    }
                } else if (scopedDependencies.size() > 1) {
                    StringBuilder message = new StringBuilder();
                    for (Scope scope : scopes) {
                        message.append(Scopes.getReadableSource(scope)).append(' ');
                    }
                    message.append(descriptor.componentDefinitionType().getQualifiedName()).append(" depends on more than one scoped component:\n");
                    BindingGraphValidator.this.appendIndentedComponentsList(message, (Iterable)scopedDependencies);
                    this.report(graph).addError(message.toString(), descriptor.componentDefinitionType(), descriptor.componentAnnotation());
                } else if (!BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().equals((Object)ValidationType.NONE)) {
                    this.validateDependencyScopeHierarchy(graph, descriptor.componentDefinitionType(), new ArrayDeque<ImmutableSet<Scope>>(), new ArrayDeque<TypeElement>());
                }
            } else if (!scopedDependencies.isEmpty()) {
                StringBuilder message = new StringBuilder(descriptor.componentDefinitionType().getQualifiedName()).append(" (unscoped) cannot depend on scoped components:\n");
                BindingGraphValidator.this.appendIndentedComponentsList(message, (Iterable)scopedDependencies);
                this.report(graph).addError(message.toString(), descriptor.componentDefinitionType(), descriptor.componentAnnotation());
            }
        }

        private void validateModules(BindingGraph graph) {
            block0: for (ModuleDescriptor module : graph.componentDescriptor().transitiveModules()) {
                if (!module.moduleElement().getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                for (ContributionBinding binding : module.bindings()) {
                    if (!binding.requiresModuleInstance()) continue;
                    this.report(graph).addError(ErrorMessages.abstractModuleHasInstanceBindingMethods(module));
                    continue block0;
                }
            }
        }

        private void validateBuilders(BindingGraph graph) {
            Sets.SetView missingSetters;
            ComponentDescriptor componentDesc = graph.componentDescriptor();
            if (!componentDesc.builderSpec().isPresent()) {
                return;
            }
            ImmutableSet<ComponentRequirement> availableDependencies = graph.availableDependencies();
            Set requiredDependencies = Sets.filter(availableDependencies, input -> input.nullPolicy(BindingGraphValidator.this.elements, BindingGraphValidator.this.types).equals((Object)ComponentRequirement.NullPolicy.THROW));
            ComponentDescriptor.BuilderSpec spec = componentDesc.builderSpec().get();
            ImmutableSet declaredSetters = spec.requirementMethods().stream().filter(method -> !method.requirement().kind().equals((Object)ComponentRequirement.Kind.BOUND_INSTANCE)).collect(DaggerStreams.toImmutableSet());
            ImmutableSet declaredRequirements = declaredSetters.stream().map(ComponentDescriptor.BuilderRequirementMethod::requirement).collect(DaggerStreams.toImmutableSet());
            ErrorMessages.ComponentBuilderMessages msgs = ErrorMessages.builderMsgsFor(graph.componentDescriptor().kind());
            Sets.SetView extraSetters = Sets.difference(declaredRequirements, availableDependencies);
            if (!extraSetters.isEmpty()) {
                List excessMethods = declaredSetters.stream().filter(arg_0 -> ComponentValidation.lambda$validateBuilders$7((Set)extraSetters, arg_0)).map(ComponentDescriptor.BuilderRequirementMethod::method).collect(Collectors.toList());
                Optional<DeclaredType> container = Optional.of(MoreTypes.asDeclared(spec.builderDefinitionType().asType()));
                String formatted = excessMethods.stream().map(method -> BindingGraphValidator.this.methodSignatureFormatter.format((ExecutableElement)method, container)).collect(Collectors.joining(", ", "[", "]"));
                this.report(graph).addError(String.format(msgs.extraSetters(), formatted), spec.builderDefinitionType());
            }
            if (!(missingSetters = Sets.difference((Set)requiredDependencies, declaredRequirements)).isEmpty()) {
                this.report(graph).addError(String.format(msgs.missingSetters(), missingSetters.stream().map(ComponentRequirement::type).collect(Collectors.toList())), spec.builderDefinitionType());
            }
            Map declaredRequirementsByType = spec.requirementMethods().stream().filter(method -> !method.requirement().kind().equals((Object)ComponentRequirement.Kind.BOUND_INSTANCE)).collect(Collectors.groupingBy(method -> method.requirement().wrappedType(), Collectors.mapping(method -> method.method(), Collectors.toList())));
            for (Map.Entry entry : declaredRequirementsByType.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                TypeMirror type = (TypeMirror)entry.getKey().get();
                this.report(graph).addError(String.format(msgs.manyMethodsForType(), type, entry.getValue()), spec.builderDefinitionType());
            }
        }

        private void validateDependencyScopeHierarchy(BindingGraph graph, TypeElement dependency, Deque<ImmutableSet<Scope>> scopeStack, Deque<TypeElement> scopedDependencyStack) {
            ImmutableSet<Scope> scopes = Scopes.scopesOf(dependency);
            if (this.stackOverlaps(scopeStack, scopes)) {
                scopedDependencyStack.push(dependency);
                StringBuilder message = new StringBuilder();
                message.append(graph.componentType().getQualifiedName());
                message.append(" depends on scoped components in a non-hierarchical scope ordering:\n");
                BindingGraphValidator.this.appendIndentedComponentsList(message, scopedDependencyStack);
                if (BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent()) {
                    this.report(graph).addItem(message.toString(), BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), graph.componentType(), ConfigurationAnnotations.getComponentAnnotation(graph.componentType()).get());
                }
                scopedDependencyStack.pop();
            } else {
                DaggerElements.getAnnotationMirror(dependency, Component.class).ifPresent(componentAnnotation -> {
                    ImmutableSet scopedDependencies = BindingGraphValidator.this.scopedTypesIn(MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies(componentAnnotation)));
                    if (scopedDependencies.size() == 1) {
                        scopeStack.push(scopes);
                        scopedDependencyStack.push(dependency);
                        this.validateDependencyScopeHierarchy(graph, (TypeElement)Iterables.getOnlyElement((Iterable)scopedDependencies), scopeStack, scopedDependencyStack);
                        scopedDependencyStack.pop();
                        scopeStack.pop();
                    }
                });
            }
        }

        private <T> boolean stackOverlaps(Deque<ImmutableSet<T>> stack, ImmutableSet<T> set) {
            for (ImmutableSet<T> entry : stack) {
                if (Sets.intersection(entry, set).isEmpty()) continue;
                return true;
            }
            return false;
        }

        private void checkBindingScope(ContributionBinding binding, ComponentDescriptor owningComponent) {
            if (binding.scope().isPresent() && !binding.scope().get().isReusable() && !owningComponent.scopes().contains((Object)binding.scope().get())) {
                this.incompatiblyScopedBindings.put((Object)owningComponent, (Object)binding);
            }
        }

        private void checkScopedBindings(BindingGraph graph) {
            if (!this.incompatiblyScopedBindings.containsKey((Object)graph.componentDescriptor())) {
                return;
            }
            StringBuilder message = new StringBuilder(graph.componentType().getQualifiedName());
            if (!graph.componentDescriptor().scopes().isEmpty()) {
                message.append(" scoped with ");
                for (Scope scope : graph.componentDescriptor().scopes()) {
                    message.append(Scopes.getReadableSource(scope)).append(' ');
                }
                message.append("may not reference bindings with different scopes:\n");
            } else {
                message.append(" (unscoped) may not reference scoped bindings:\n");
            }
            for (ContributionBinding binding : this.incompatiblyScopedBindings.get((Object)graph.componentDescriptor())) {
                message.append("    ");
                switch (binding.kind()) {
                    case DELEGATE: 
                    case PROVISION: {
                        message.append(BindingGraphValidator.this.methodSignatureFormatter.format(MoreElements.asExecutable(binding.bindingElement().get())));
                        break;
                    }
                    case INJECTION: {
                        message.append(Scopes.getReadableSource(binding.scope().get())).append(" class ").append(binding.bindingTypeElement().get().getQualifiedName());
                        break;
                    }
                    default: {
                        throw new AssertionError(binding);
                    }
                }
                message.append("\n");
            }
            this.report(graph).addError(message.toString(), graph.componentType(), graph.componentDescriptor().componentAnnotation());
        }

        private static /* synthetic */ boolean lambda$validateBuilders$7(Set extraSetters, ComponentDescriptor.BuilderRequirementMethod method) {
            return extraSetters.contains(method.requirement());
        }

        final class BindingGraphValidation
        extends ComponentTreeTraverser.BindingGraphTraverser {
            BindingGraphValidation(ComponentTreeTraverser.ComponentTreePath componentPath, ComponentDescriptor.ComponentMethodDescriptor entryPointMethod) {
                super(componentPath, entryPointMethod);
            }

            private void reportErrorAtEntryPoint(String format, Object ... args) {
                this.reportErrorAtEntryPoint(this.currentGraph(), format, args);
            }

            private void reportErrorAtEntryPoint(BindingGraph graph, String format, Object ... args) {
                String message = args.length == 0 ? format : String.format(format, args);
                ComponentValidation.this.report(graph).addError(message, this.entryPointElement());
            }

            private String formatDependencyTrace() {
                return BindingGraphValidator.this.dependencyRequestFormatter.format(this.dependencyTrace());
            }

            @Override
            protected void visitDependencyRequest(DependencyRequest dependencyRequest) {
                if (this.atDependencyCycle()) {
                    this.reportDependencyCycle();
                } else {
                    super.visitDependencyRequest(dependencyRequest);
                }
            }

            @Override
            protected void visitContributionBinding(ContributionBinding binding, ComponentDescriptor owningComponent) {
                ComponentValidation.this.checkBindingScope(binding, owningComponent);
                if (BindingGraphValidator.this.compilerOptions.usesProducers()) {
                    Key productionImplementationExecutorKey = BindingGraphValidator.this.keyFactory.forProductionImplementationExecutor();
                    if (!binding.key().equals(productionImplementationExecutorKey)) {
                        Key productionExecutorKey = BindingGraphValidator.this.keyFactory.forProductionExecutor();
                        for (DependencyRequest request : binding.explicitDependencies()) {
                            if (!request.key().equals(productionExecutorKey) && !request.key().equals(productionImplementationExecutorKey)) continue;
                            this.reportDependsOnProductionExecutor();
                        }
                    }
                }
                super.visitContributionBinding(binding, owningComponent);
            }

            private void reportDependsOnProductionExecutor() {
                this.reportErrorAtEntryPoint("%s may not depend on the production executor.", this.formatCurrentDependencyRequestKey());
            }

            private void reportDependencyCycle() {
                if (!this.providersBreakingCycle().isEmpty()) {
                    return;
                }
                ImmutableList.Builder cycleBindings = ImmutableList.builder();
                this.cycleDependencyTrace().forEach((dependencyRequest, resolvedBindings) -> cycleBindings.addAll(resolvedBindings.contributionBindings()));
                this.reportErrorAtEntryPoint(this.owningGraph((Iterable<ContributionBinding>)cycleBindings.build()), "Found a dependency cycle:\n%s", this.formatDependencyTrace());
            }

            private ImmutableSet<DependencyRequest> providersBreakingCycle() {
                ImmutableSet.Builder providers = ImmutableSet.builder();
                AtomicBoolean first = new AtomicBoolean(true);
                this.cycleDependencyTrace().forEach((dependencyRequest, resolvedBindings) -> {
                    TypeMirror optionalValueType;
                    RequestKind requestKind;
                    if (first.getAndSet(false) || !dependencyRequest.requestElement().isPresent()) {
                        return;
                    }
                    if (this.breaksCycle(dependencyRequest.key().type(), dependencyRequest.kind())) {
                        providers.add(dependencyRequest);
                    } else if (!resolvedBindings.optionalBindingDeclarations().isEmpty() && this.breaksCycle(RequestKinds.extractKeyType(requestKind = RequestKinds.getRequestKind(optionalValueType = OptionalType.from(dependencyRequest.key()).valueType()), optionalValueType), requestKind)) {
                        providers.add(dependencyRequest);
                    }
                });
                return providers.build();
            }

            private boolean breaksCycle(TypeMirror requestedType, RequestKind requestKind) {
                switch (requestKind) {
                    case PROVIDER: 
                    case LAZY: 
                    case PROVIDER_OF_LAZY: {
                        return true;
                    }
                    case INSTANCE: {
                        return MapType.isMap(requestedType) && MapType.from(requestedType).valuesAreTypeOf(Provider.class);
                    }
                }
                return false;
            }

            private String formatCurrentDependencyRequestKey() {
                return this.dependencyRequest().key().toString();
            }
        }
    }
}

