/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.shaded.auto.common.GeneratedAnnotations;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

abstract class SourceFileGenerator<T> {
    private static final String GENERATED_COMMENTS = "https://google.github.io/dagger";
    private final Filer filer;
    private final Elements elements;
    private final SourceVersion sourceVersion;

    SourceFileGenerator(Filer filer, Elements elements, SourceVersion sourceVersion) {
        this.filer = (Filer)Preconditions.checkNotNull((Object)filer);
        this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        this.sourceVersion = (SourceVersion)((Object)Preconditions.checkNotNull((Object)((Object)sourceVersion)));
    }

    void generate(T input, Messager messager) {
        try {
            this.generate(input);
        }
        catch (SourceFileGenerationException e) {
            e.printMessageTo(messager);
        }
    }

    void generate(T input) throws SourceFileGenerationException {
        ClassName generatedTypeName = this.nameGeneratedType(input);
        Optional<TypeSpec.Builder> type = this.write(generatedTypeName, input);
        if (!type.isPresent()) {
            return;
        }
        try {
            this.buildJavaFile(generatedTypeName, type.get()).writeTo(this.filer);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, SourceFileGenerationException.class);
            throw new SourceFileGenerationException(Optional.empty(), e, this.getElementForErrorReporting(input));
        }
    }

    private JavaFile buildJavaFile(ClassName generatedTypeName, TypeSpec.Builder typeSpecBuilder) {
        Optional<AnnotationSpec> generatedAnnotation = GeneratedAnnotations.generatedAnnotation(this.elements, this.sourceVersion).map(annotation -> AnnotationSpec.builder((ClassName)ClassName.get((TypeElement)annotation)).addMember("value", "$S", new Object[]{"dagger.internal.codegen.ComponentProcessor"}).addMember("comments", "$S", new Object[]{GENERATED_COMMENTS}).build());
        generatedAnnotation.ifPresent(arg_0 -> ((TypeSpec.Builder)typeSpecBuilder).addAnnotation(arg_0));
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)generatedTypeName.packageName(), (TypeSpec)typeSpecBuilder.build()).skipJavaLangImports(true);
        if (!generatedAnnotation.isPresent()) {
            javaFileBuilder.addFileComment("Generated by Dagger ($L).", new Object[]{GENERATED_COMMENTS});
        }
        return javaFileBuilder.build();
    }

    abstract ClassName nameGeneratedType(T var1);

    abstract Optional<? extends Element> getElementForErrorReporting(T var1);

    abstract Optional<TypeSpec.Builder> write(ClassName var1, T var2);
}

