/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.BindingFactory;
import dagger.internal.codegen.FactoryGenerator;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.ProducerFactoryGenerator;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class ModuleProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final ModuleValidator moduleValidator;
    private final BindingFactory bindingFactory;
    private final FactoryGenerator factoryGenerator;
    private final ProducerFactoryGenerator producerFactoryGenerator;
    private final Set<TypeElement> processedModuleElements = Sets.newLinkedHashSet();

    @Inject
    ModuleProcessingStep(Messager messager, ModuleValidator moduleValidator, BindingFactory bindingFactory, FactoryGenerator factoryGenerator, ProducerFactoryGenerator producerFactoryGenerator) {
        this.messager = messager;
        this.moduleValidator = moduleValidator;
        this.bindingFactory = bindingFactory;
        this.factoryGenerator = factoryGenerator;
        this.producerFactoryGenerator = producerFactoryGenerator;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(Module.class, ProducerModule.class);
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        List<TypeElement> modules = ElementFilter.typesIn(elementsByAnnotation.values());
        this.moduleValidator.addKnownModules(modules);
        for (TypeElement module : modules) {
            if (!this.processedModuleElements.add(module)) continue;
            this.processModule(module);
        }
        return ImmutableSet.of();
    }

    private void processModule(TypeElement module) {
        ValidationReport<TypeElement> report = this.moduleValidator.validate(module);
        report.printMessagesTo(this.messager);
        if (report.isClean()) {
            for (ExecutableElement method : ElementFilter.methodsIn(module.getEnclosedElements())) {
                if (MoreElements.isAnnotationPresent(method, Provides.class)) {
                    this.factoryGenerator.generate(this.bindingFactory.providesMethodBinding(method, module), this.messager);
                    continue;
                }
                if (!MoreElements.isAnnotationPresent(method, Produces.class)) continue;
                this.producerFactoryGenerator.generate(this.bindingFactory.producesMethodBinding(method, module), this.messager);
            }
        }
    }
}

