/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.googlejavaformat.java.filer.FormattingFiler;
import dagger.Binds;
import dagger.BindsInstance;
import dagger.Component;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.BindingGraphPluginsModule;
import dagger.internal.codegen.BindingMethodProcessingStep;
import dagger.internal.codegen.BindingMethodValidatorsModule;
import dagger.internal.codegen.BindsInstanceProcessingStep;
import dagger.internal.codegen.CanReleaseReferencesProcessingStep;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentHjarProcessingStep;
import dagger.internal.codegen.ComponentProcessingStep;
import dagger.internal.codegen.DaggerComponentProcessor_ProcessorComponent;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.FactoryGenerator;
import dagger.internal.codegen.ForReleasableReferencesValidator;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.InjectBindingRegistryImpl;
import dagger.internal.codegen.InjectProcessingStep;
import dagger.internal.codegen.MapKeyProcessingStep;
import dagger.internal.codegen.MembersInjectorGenerator;
import dagger.internal.codegen.ModuleProcessingStep;
import dagger.internal.codegen.MonitoringModuleProcessingStep;
import dagger.internal.codegen.MultibindingAnnotationsProcessingStep;
import dagger.internal.codegen.ProcessingOptions;
import dagger.internal.codegen.ProductionExecutorModuleProcessingStep;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.spi.BindingGraphPlugin;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public final class ComponentProcessor
extends BasicAnnotationProcessor {
    @Inject
    InjectBindingRegistry injectBindingRegistry;
    @Inject
    FactoryGenerator factoryGenerator;
    @Inject
    MembersInjectorGenerator membersInjectorGenerator;
    @Inject
    ImmutableList<BindingGraphPlugin> bindingGraphPlugins;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedOptions() {
        ImmutableSet.Builder options = ImmutableSet.builder();
        options.addAll(CompilerOptions.SUPPORTED_OPTIONS);
        for (BindingGraphPlugin plugin : this.bindingGraphPlugins) {
            options.addAll((Iterable)plugin.supportedOptions());
        }
        return options.build();
    }

    @Override
    protected Iterable<? extends BasicAnnotationProcessor.ProcessingStep> initSteps() {
        Messager messager = this.processingEnv.getMessager();
        DaggerElements elements = new DaggerElements(this.processingEnv);
        CompilerOptions compilerOptions = CompilerOptions.create(this.processingEnv, elements);
        ProcessorComponent.Builder builder = DaggerComponentProcessor_ProcessorComponent.builder().types(this.processingEnv.getTypeUtils()).elements(elements).sourceVersion(this.processingEnv.getSourceVersion()).messager(messager).processingOptions(this.processingEnv.getOptions()).compilerOptions(compilerOptions);
        if (compilerOptions.headerCompilation()) {
            builder.filer(this.processingEnv.getFiler());
        } else {
            builder.filer((Filer)new FormattingFiler(this.processingEnv.getFiler()));
        }
        ProcessorComponent component = builder.build();
        component.inject(this);
        return component.processingSteps();
    }

    @Override
    protected void postRound(RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            try {
                this.injectBindingRegistry.generateSourcesForRequiredBindings(this.factoryGenerator, this.membersInjectorGenerator);
            }
            catch (SourceFileGenerationException e) {
                e.printMessageTo(this.processingEnv.getMessager());
            }
        }
    }

    @Module
    static interface ProcessingStepsModule {
        @Provides
        public static ImmutableList<BasicAnnotationProcessor.ProcessingStep> processingSteps(MapKeyProcessingStep mapKeyProcessingStep, ForReleasableReferencesValidator forReleasableReferencesValidator, CanReleaseReferencesProcessingStep canReleaseReferencesProcessingStep, InjectProcessingStep injectProcessingStep, MonitoringModuleProcessingStep monitoringModuleProcessingStep, ProductionExecutorModuleProcessingStep productionExecutorModuleProcessingStep, MultibindingAnnotationsProcessingStep multibindingAnnotationsProcessingStep, BindsInstanceProcessingStep bindsInstanceProcessingStep, ModuleProcessingStep moduleProcessingStep, ComponentProcessingStep componentProcessingStep, ComponentHjarProcessingStep componentHjarProcessingStep, BindingMethodProcessingStep bindingMethodProcessingStep, CompilerOptions compilerOptions) {
            return ImmutableList.of((Object)mapKeyProcessingStep, (Object)forReleasableReferencesValidator, (Object)canReleaseReferencesProcessingStep, (Object)injectProcessingStep, (Object)monitoringModuleProcessingStep, (Object)productionExecutorModuleProcessingStep, (Object)multibindingAnnotationsProcessingStep, (Object)bindsInstanceProcessingStep, (Object)moduleProcessingStep, (Object)(compilerOptions.headerCompilation() ? componentHjarProcessingStep : componentProcessingStep), (Object)bindingMethodProcessingStep);
        }

        @Binds
        public InjectBindingRegistry injectBindingRegistry(InjectBindingRegistryImpl var1);
    }

    @Singleton
    @Component(modules={BindingMethodValidatorsModule.class, BindingGraphPluginsModule.class, ProcessingStepsModule.class})
    static interface ProcessorComponent {
        public void inject(ComponentProcessor var1);

        public ImmutableList<BasicAnnotationProcessor.ProcessingStep> processingSteps();

        @CanIgnoreReturnValue
        @Component.Builder
        public static interface Builder {
            @BindsInstance
            public Builder messager(Messager var1);

            @BindsInstance
            public Builder filer(Filer var1);

            @BindsInstance
            public Builder types(Types var1);

            @BindsInstance
            public Builder elements(Elements var1);

            @BindsInstance
            public Builder sourceVersion(SourceVersion var1);

            @BindsInstance
            public Builder compilerOptions(CompilerOptions var1);

            @BindsInstance
            public Builder processingOptions(@ProcessingOptions Map<String, String> var1);

            @CheckReturnValue
            public ProcessorComponent build();
        }
    }
}

