/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentTreeTraverser;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.model.BindingGraph;
import dagger.model.BindingGraphProxies;
import dagger.model.BindingKind;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

final class BindingGraphConverter
extends ComponentTreeTraverser {
    private final MutableNetwork<BindingGraph.Node, BindingGraph.Edge> network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
    private BindingGraph.ComponentNode parentComponent;
    private BindingGraph.ComponentNode currentComponent;

    private BindingGraphConverter(BindingGraph graph) {
        super(graph);
    }

    static dagger.model.BindingGraph convert(BindingGraph graph) {
        BindingGraphConverter converter = new BindingGraphConverter(graph);
        converter.traverseComponents();
        return BindingGraphProxies.bindingGraph(converter.network);
    }

    @Override
    protected void visitComponent(BindingGraph graph) {
        BindingGraph.ComponentNode grandparentNode = this.parentComponent;
        this.parentComponent = this.currentComponent;
        this.currentComponent = BindingGraphProxies.componentNode(this.componentTreePath().toComponentPath());
        this.network.addNode((Object)this.currentComponent);
        super.visitComponent(graph);
        this.currentComponent = this.parentComponent;
        this.parentComponent = grandparentNode;
    }

    @Override
    protected void visitSubcomponentFactoryMethod(BindingGraph graph, BindingGraph parent, ExecutableElement factoryMethod) {
        this.network.addEdge((Object)this.parentComponent, (Object)this.currentComponent, (Object)BindingGraphProxies.childFactoryMethodEdge(factoryMethod));
        super.visitSubcomponentFactoryMethod(graph, parent, factoryMethod);
    }

    @Override
    protected ComponentTreeTraverser.BindingGraphTraverser bindingGraphTraverser(ComponentTreeTraverser.ComponentTreePath componentTreePath, ComponentDescriptor.ComponentMethodDescriptor entryPointMethod) {
        return new BindingGraphVisitor(componentTreePath, entryPointMethod);
    }

    private final class BindingGraphVisitor
    extends ComponentTreeTraverser.BindingGraphTraverser {
        private BindingGraph.Node current;

        BindingGraphVisitor(ComponentTreeTraverser.ComponentTreePath componentTreePath, ComponentDescriptor.ComponentMethodDescriptor entryPointMethod) {
            super(componentTreePath, entryPointMethod);
            this.current = BindingGraphConverter.this.currentComponent;
            BindingGraphConverter.this.network.addNode((Object)this.current);
        }

        @Override
        protected void visitBinding(Binding binding, ComponentDescriptor owningComponent) {
            ContributionBinding contributionBinding;
            BindingGraph.Node previous = this.current;
            this.current = this.bindingNode(this.resolvedBindings(), binding, owningComponent);
            BindingGraphConverter.this.network.addNode((Object)this.current);
            if (binding instanceof ContributionBinding && (contributionBinding = (ContributionBinding)binding).kind().equals((Object)BindingKind.SUBCOMPONENT_BUILDER)) {
                ImmutableSet.Builder modules = ImmutableSet.builder();
                for (SubcomponentDeclaration subcomponentDeclaration : this.resolvedBindings().subcomponentDeclarations()) {
                    modules.add((Object)subcomponentDeclaration.contributingModule().get());
                }
                BindingGraphConverter.this.network.addEdge((Object)this.current, (Object)this.subcomponentNode(contributionBinding, owningComponent), (Object)BindingGraphProxies.subcomponentBuilderBindingEdge((Iterable<TypeElement>)modules.build()));
            }
            if (BindingGraphConverter.this.network.edgesConnecting((Object)previous, (Object)this.current).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).noneMatch(e -> e.dependencyRequest().equals(this.dependencyRequest()))) {
                BindingGraphConverter.this.network.addEdge((Object)previous, (Object)this.current, (Object)BindingGraphProxies.dependencyEdge(this.dependencyRequest(), this.atEntryPoint()));
                super.visitBinding(binding, owningComponent);
            }
            this.current = previous;
        }

        private BindingGraph.ComponentNode subcomponentNode(ContributionBinding binding, ComponentDescriptor subcomponentParent) {
            Preconditions.checkArgument((boolean)binding.kind().equals((Object)BindingKind.SUBCOMPONENT_BUILDER));
            TypeElement builderType = MoreTypes.asTypeElement(binding.key().type());
            TypeElement subcomponentType = MoreElements.asType(builderType.getEnclosingElement());
            ComponentTreeTraverser.ComponentTreePath childPath = this.componentTreePath().pathFromRootToAncestor(subcomponentParent).childPath(subcomponentType);
            BindingGraph.ComponentNode childNode = BindingGraphProxies.componentNode(childPath.toComponentPath());
            BindingGraphConverter.this.network.addNode((Object)childNode);
            return childNode;
        }

        private BindingGraph.BindingNode bindingNode(ResolvedBindings resolvedBindings, Binding binding, ComponentDescriptor owningComponent) {
            ImmutableList.Builder associatedDeclarations = ImmutableList.builder();
            for (BindingDeclaration declaration : Iterables.concat(resolvedBindings.multibindingDeclarations(), resolvedBindings.optionalBindingDeclarations(), resolvedBindings.subcomponentDeclarations())) {
                associatedDeclarations.add((Object)declaration.bindingElement().get());
            }
            return BindingGraphProxies.bindingNode(this.componentTreePath().pathFromRootToAncestor(owningComponent).toComponentPath(), binding, (Iterable<Element>)associatedDeclarations.build());
        }
    }
}

