/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Preconditions;
import dagger.internal.codegen.AbstractComponentWriter;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementField;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

final class SubcomponentWriter
extends AbstractComponentWriter {
    private final AbstractComponentWriter parent;
    private final Optional<ComponentDescriptor.ComponentMethodDescriptor> subcomponentFactoryMethod;

    SubcomponentWriter(AbstractComponentWriter parent, BindingGraph graph) {
        super(parent, SubcomponentWriter.subcomponentModel(parent, graph), graph, parent.componentRequirementFields.forChildComponent());
        this.parent = parent;
        this.subcomponentFactoryMethod = Optional.ofNullable((ComponentDescriptor.ComponentMethodDescriptor)parent.graph.componentDescriptor().subcomponentsByFactoryMethod().inverse().get((Object)graph.componentDescriptor()));
    }

    private static GeneratedComponentModel subcomponentModel(AbstractComponentWriter parent, BindingGraph graph) {
        ClassName parentName = parent.generatedComponentModel.name();
        ClassName name = parentName.nestedClass(parent.subcomponentNames.get(graph.componentDescriptor()) + "Impl");
        return GeneratedComponentModel.forSubcomponent(name);
    }

    private ExecutableType resolvedSubcomponentFactoryMethod() {
        com.google.common.base.Preconditions.checkState((boolean)this.subcomponentFactoryMethod.isPresent(), (String)"%s does not have a factory method for %s", (Object)this.parent.graph.componentType(), (Object)this.graph.componentType());
        return MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(this.parent.graph.componentType().asType()), this.subcomponentFactoryMethod.get().methodElement()));
    }

    @Override
    protected void addBuilderClass(TypeSpec builder) {
        this.parent.generatedComponentModel.addType(GeneratedComponentModel.TypeSpecKind.SUBCOMPONENT, builder);
    }

    @Override
    protected void addFactoryMethods() {
        if (!this.subcomponentFactoryMethod.isPresent() || !this.subcomponentFactoryMethod.get().kind().isSubcomponentKind()) {
            return;
        }
        MethodSpec.Builder componentMethod = MethodSpec.methodBuilder((String)this.subcomponentFactoryMethod.get().methodElement().getSimpleName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class);
        ExecutableType resolvedMethod = this.resolvedSubcomponentFactoryMethod();
        componentMethod.returns(ClassName.get((TypeMirror)resolvedMethod.getReturnType()));
        this.writeSubcomponentWithoutBuilder(componentMethod, resolvedMethod);
        this.parent.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.COMPONENT_METHOD, componentMethod.build());
    }

    private void writeSubcomponentWithoutBuilder(MethodSpec.Builder componentMethod, ExecutableType resolvedMethod) {
        ImmutableList.Builder subcomponentConstructorParameters = ImmutableList.builder();
        List<? extends VariableElement> params = this.subcomponentFactoryMethod.get().methodElement().getParameters();
        List<? extends TypeMirror> paramTypes = resolvedMethod.getParameterTypes();
        for (int i = 0; i < params.size(); ++i) {
            VariableElement moduleVariable = params.get(i);
            TypeElement moduleTypeElement = MoreTypes.asTypeElement(paramTypes.get(i));
            ComponentRequirement componentRequirement = ComponentRequirement.forModule(moduleTypeElement.asType());
            TypeName moduleType = TypeName.get((TypeMirror)paramTypes.get(i));
            componentMethod.addParameter(moduleType, moduleVariable.getSimpleName().toString(), new Modifier[0]);
            if (this.componentRequirementFields.contains(componentRequirement)) continue;
            String preferredModuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, moduleTypeElement.getSimpleName().toString());
            FieldSpec contributionField = this.componentField((TypeName)ClassName.get((TypeElement)moduleTypeElement), preferredModuleName).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
            this.generatedComponentModel.addField(GeneratedComponentModel.FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, contributionField);
            this.constructor.addParameter(moduleType, contributionField.name, new Modifier[0]).addStatement("this.$1N = $2T.checkNotNull($1N)", new Object[]{contributionField, Preconditions.class});
            this.componentRequirementFields.add(ComponentRequirementField.componentField(componentRequirement, contributionField, this.generatedComponentModel.name()));
            subcomponentConstructorParameters.add((Object)CodeBlock.of((String)"$L", (Object[])new Object[]{moduleVariable.getSimpleName()}));
        }
        Set uninitializedModules = Sets.filter(this.graph.componentRequirements(), (Predicate)Predicates.not(this.componentRequirementFields::contains));
        for (ComponentRequirement componentRequirement : uninitializedModules) {
            com.google.common.base.Preconditions.checkState((boolean)componentRequirement.kind().equals((Object)ComponentRequirement.Kind.MODULE));
            TypeElement moduleType = componentRequirement.typeElement();
            String preferredModuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, moduleType.getSimpleName().toString());
            FieldSpec contributionField = this.componentField((TypeName)ClassName.get((TypeElement)moduleType), preferredModuleName).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
            this.generatedComponentModel.addField(GeneratedComponentModel.FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, contributionField);
            this.constructor.addStatement("this.$N = new $T()", new Object[]{contributionField, ClassName.get((TypeElement)moduleType)});
            this.componentRequirementFields.add(ComponentRequirementField.componentField(componentRequirement, contributionField, this.generatedComponentModel.name()));
        }
        componentMethod.addStatement("return new $T($L)", new Object[]{this.generatedComponentModel.name(), CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)subcomponentConstructorParameters.build())});
    }

    private final FieldSpec.Builder componentField(TypeName type, String name) {
        return FieldSpec.builder((TypeName)type, (String)this.generatedComponentModel.getUniqueFieldName(name), (Modifier[])new Modifier[0]);
    }
}

