/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.FrameworkInstanceBindingExpression;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MembersInjectionMethods;
import dagger.model.RequestKind;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

final class MembersInjectionBindingExpression
extends BindingExpression {
    private final FrameworkInstanceBindingExpression membersInjectorExpression;
    private final GeneratedComponentModel generatedComponentModel;
    private final MembersInjectionBinding binding;
    private final MembersInjectionMethods membersInjectionMethods;

    MembersInjectionBindingExpression(FrameworkInstanceBindingExpression membersInjectorExpression, GeneratedComponentModel generatedComponentModel, MembersInjectionMethods membersInjectionMethods) {
        super(membersInjectorExpression.resolvedBindings(), membersInjectorExpression.requestKind());
        Preconditions.checkArgument((boolean)this.bindingKey().kind().equals((Object)BindingKey.Kind.MEMBERS_INJECTION));
        Preconditions.checkArgument((boolean)this.requestKind().equals((Object)RequestKind.MEMBERS_INJECTOR));
        this.membersInjectorExpression = membersInjectorExpression;
        this.generatedComponentModel = generatedComponentModel;
        this.binding = this.resolvedBindings().membersInjectionBinding().get();
        this.membersInjectionMethods = membersInjectionMethods;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        return this.membersInjectorExpression.getDependencyExpression(requestingClass);
    }

    @Override
    protected CodeBlock doGetComponentMethodImplementation(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ClassName requestingClass) {
        ExecutableElement methodElement = componentMethod.methodElement();
        List<? extends VariableElement> parameters = methodElement.getParameters();
        if (parameters.isEmpty()) {
            return this.membersInjectorExpression.getComponentMethodImplementation(componentMethod, this.generatedComponentModel.name());
        }
        ParameterSpec parameter = ParameterSpec.get((VariableElement)((VariableElement)Iterables.getOnlyElement(parameters)));
        if (this.binding.injectionSites().isEmpty()) {
            return methodElement.getReturnType().getKind().equals((Object)TypeKind.VOID) ? CodeBlock.of((String)"", (Object[])new Object[0]) : CodeBlock.of((String)"return $N;", (Object[])new Object[]{parameter});
        }
        return methodElement.getReturnType().getKind().equals((Object)TypeKind.VOID) ? CodeBlock.of((String)"$L;", (Object[])new Object[]{this.membersInjectionInvocation(parameter)}) : CodeBlock.of((String)"return $L;", (Object[])new Object[]{this.membersInjectionInvocation(parameter)});
    }

    CodeBlock membersInjectionInvocation(ParameterSpec target) {
        return CodeBlock.of((String)"$N($N)", (Object[])new Object[]{this.membersInjectionMethods.getOrCreate(this.binding.key()), target});
    }
}

