/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.DelegateFactory;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.FrameworkFieldSupplier;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.ResolvedBindings;
import java.util.Optional;
import javax.lang.model.element.Modifier;

abstract class FrameworkFieldInitializer
implements FrameworkFieldSupplier {
    protected final GeneratedComponentModel generatedComponentModel;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final ResolvedBindings resolvedBindings;
    private FieldSpec fieldSpec;
    private InitializationState fieldInitializationState = InitializationState.UNINITIALIZED;
    private Optional<TypeName> fieldTypeReplacement = Optional.empty();

    protected FrameworkFieldInitializer(GeneratedComponentModel generatedComponentModel, ComponentBindingExpressions componentBindingExpressions, ResolvedBindings resolvedBindings) {
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
        this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
        this.resolvedBindings = (ResolvedBindings)Preconditions.checkNotNull((Object)resolvedBindings);
    }

    @Override
    public final MemberSelect memberSelect() {
        this.initializeField();
        return MemberSelect.localField(this.generatedComponentModel.name(), ((FieldSpec)Preconditions.checkNotNull((Object)this.fieldSpec)).name);
    }

    private void initializeField() {
        switch (this.fieldInitializationState) {
            case UNINITIALIZED: {
                this.fieldInitializationState = InitializationState.INITIALIZING;
                CodeBlock.Builder codeBuilder = CodeBlock.builder();
                CodeBlock fieldInitialization = this.getFieldInitialization();
                CodeBlock initCode = CodeBlock.of((String)"this.$N = $L;", (Object[])new Object[]{this.getOrCreateField(), fieldInitialization});
                if (this.fieldInitializationState == InitializationState.DELEGATED) {
                    CodeBlock delegateFactoryVariable = CodeBlock.of((String)"$NDelegate", (Object[])new Object[]{this.fieldSpec});
                    codeBuilder.add("$1T $2L = ($1T) $3N;", new Object[]{DelegateFactory.class, delegateFactoryVariable, this.fieldSpec}).add(initCode).add("$L.setDelegatedProvider($N);", new Object[]{delegateFactoryVariable, this.fieldSpec});
                } else {
                    codeBuilder.add(initCode);
                }
                this.generatedComponentModel.addInitialization(codeBuilder.build());
                this.fieldInitializationState = InitializationState.INITIALIZED;
                break;
            }
            case INITIALIZING: {
                this.generatedComponentModel.addInitialization(CodeBlock.of((String)"this.$N = new $T<>();", (Object[])new Object[]{this.getOrCreateField(), DelegateFactory.class}));
                this.fieldInitializationState = InitializationState.DELEGATED;
                break;
            }
            case DELEGATED: 
            case INITIALIZED: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled initialization state: " + (Object)((Object)this.fieldInitializationState)));
            }
        }
    }

    private FieldSpec getOrCreateField() {
        if (this.fieldSpec != null) {
            return this.fieldSpec;
        }
        boolean useRawType = !Accessibility.isTypeAccessibleFrom(this.resolvedBindings.key().type(), this.generatedComponentModel.name().packageName());
        FrameworkField contributionBindingField = FrameworkField.forResolvedBindings(this.resolvedBindings, this.alternativeFrameworkClass());
        Object fieldType = this.fieldTypeReplacement.isPresent() ? this.fieldTypeReplacement.get() : (useRawType ? contributionBindingField.type().rawType : contributionBindingField.type());
        FieldSpec.Builder contributionField = FieldSpec.builder((TypeName)fieldType, (String)this.generatedComponentModel.getUniqueFieldName(contributionBindingField.name()), (Modifier[])new Modifier[0]);
        contributionField.addModifiers(new Modifier[]{Modifier.PRIVATE});
        if (useRawType && !this.fieldTypeReplacement.isPresent()) {
            contributionField.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
        }
        this.fieldSpec = contributionField.build();
        this.generatedComponentModel.addField(GeneratedComponentModel.FieldSpecKind.FRAMEWORK_FIELD, this.fieldSpec);
        return this.fieldSpec;
    }

    @Override
    public boolean fieldTypeReplaced() {
        return this.fieldTypeReplacement.isPresent();
    }

    protected Optional<ClassName> alternativeFrameworkClass() {
        return Optional.empty();
    }

    protected abstract CodeBlock getFieldInitialization();

    protected final ImmutableList<CodeBlock> getBindingDependencyExpressions(Binding binding) {
        ImmutableList<FrameworkDependency> dependencies = binding.frameworkDependencies();
        return dependencies.stream().map(this::getDependencyExpression).collect(DaggerStreams.toImmutableList());
    }

    protected final CodeBlock getDependencyExpression(FrameworkDependency frameworkDependency) {
        return this.componentBindingExpressions.getDependencyExpression(frameworkDependency, this.generatedComponentModel.name()).codeBlock();
    }

    protected final void setFieldTypeReplacement(TypeName typeName) {
        this.fieldTypeReplacement = Optional.of(typeName);
    }

    private static enum InitializationState {
        UNINITIALIZED,
        INITIALIZING,
        DELEGATED,
        INITIALIZED;

    }
}

