/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multimaps;
import com.google.common.collect.UnmodifiableIterator;
import dagger.internal.codegen.AutoValue_ComponentTreeTraverser_ComponentTreePath;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.ResolvedBindings;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class ComponentTreeTraverser {
    private final Deque<BindingGraph> bindingGraphPath = new ArrayDeque<BindingGraph>();

    public ComponentTreeTraverser(BindingGraph rootGraph) {
        Preconditions.checkArgument((boolean)rootGraph.componentDescriptor().kind().isTopLevel(), (String)"only top-level graphs can be traversed, not %s", (Object)rootGraph.componentDescriptor().componentDefinitionType().getQualifiedName());
        this.bindingGraphPath.add(rootGraph);
    }

    public final void traverseComponents() {
        Preconditions.checkState((this.bindingGraphPath.size() == 1 ? 1 : 0) != 0);
        this.visitComponent(this.bindingGraphPath.getFirst());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitComponent(BindingGraph graph) {
        BindingGraph parent;
        ComponentDescriptor.ComponentMethodDescriptor childFactoryMethod;
        if (this.bindingGraphPath.size() > 1 && (childFactoryMethod = (ComponentDescriptor.ComponentMethodDescriptor)(parent = (BindingGraph)Iterators.get(this.bindingGraphPath.descendingIterator(), (int)1)).componentDescriptor().subcomponentsByFactoryMethod().inverse().get((Object)graph.componentDescriptor())) != null) {
            this.visitSubcomponentFactoryMethod(graph, parent, childFactoryMethod.methodElement());
        }
        for (DependencyRequest entryPoint : graph.componentDescriptor().entryPoints()) {
            this.visitEntryPoint(entryPoint, graph);
        }
        for (BindingGraph child : graph.subgraphs()) {
            this.bindingGraphPath.addLast(child);
            try {
                this.visitComponent(child);
            }
            finally {
                Verify.verify((boolean)this.bindingGraphPath.removeLast().equals(child));
            }
        }
    }

    protected void visitSubcomponentFactoryMethod(BindingGraph graph, BindingGraph parent, ExecutableElement factoryMethod) {
    }

    protected void visitEntryPoint(DependencyRequest entryPoint, BindingGraph graph) {
        this.bindingGraphTraverser(this.componentTreePath(), entryPoint).traverseDependencies();
    }

    protected BindingGraphTraverser bindingGraphTraverser(ComponentTreePath componentPath, DependencyRequest entryPoint) {
        return new NoOpBindingGraphTraverser(componentPath, entryPoint);
    }

    protected final ComponentTreePath componentTreePath() {
        return ComponentTreePath.create(this.bindingGraphPath);
    }

    public static final class DependencyTrace {
        private final ImmutableList<DependencyRequest> dependencyRequests;
        private final ImmutableList<ResolvedBindings> resolvedBindings;

        private DependencyTrace(Iterable<DependencyRequest> dependencyRequests, Iterable<ResolvedBindings> resolvedBindings) {
            this.dependencyRequests = ImmutableList.copyOf(dependencyRequests);
            this.resolvedBindings = ImmutableList.copyOf(resolvedBindings);
            Preconditions.checkArgument((this.dependencyRequests.size() == this.resolvedBindings.size() ? 1 : 0) != 0, (String)"dependency requests and resolved bindings must have the same size: %s vs. %s", this.dependencyRequests, this.resolvedBindings);
        }

        protected final void forEach(BiConsumer<? super DependencyRequest, ? super ResolvedBindings> consumer) {
            UnmodifiableIterator dependencyRequestIterator = this.dependencyRequests.iterator();
            UnmodifiableIterator resolvedBindingsIterator = this.resolvedBindings.iterator();
            while (dependencyRequestIterator.hasNext()) {
                consumer.accept((DependencyRequest)dependencyRequestIterator.next(), (ResolvedBindings)resolvedBindingsIterator.next());
            }
        }

        protected final <T> Stream<T> transform(BiFunction<? super DependencyRequest, ? super ResolvedBindings, T> function) {
            UnmodifiableIterator dependencyRequestIterator = this.dependencyRequests.iterator();
            UnmodifiableIterator resolvedBindingsIterator = this.resolvedBindings.iterator();
            return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(this.dependencyRequests.size(), 80, (Iterator)dependencyRequestIterator, function, (Iterator)resolvedBindingsIterator){
                final /* synthetic */ Iterator val$dependencyRequestIterator;
                final /* synthetic */ BiFunction val$function;
                final /* synthetic */ Iterator val$resolvedBindingsIterator;
                {
                    this.val$dependencyRequestIterator = iterator;
                    this.val$function = biFunction;
                    this.val$resolvedBindingsIterator = iterator2;
                    super(x0, x1);
                }

                @Override
                public boolean tryAdvance(Consumer<? super T> action) {
                    if (!this.val$dependencyRequestIterator.hasNext()) {
                        return false;
                    }
                    action.accept(this.val$function.apply(this.val$dependencyRequestIterator.next(), this.val$resolvedBindingsIterator.next()));
                    return true;
                }
            }, false);
        }
    }

    public static abstract class ComponentTreePath {
        private static ComponentTreePath create(Iterable<BindingGraph> path) {
            return new AutoValue_ComponentTreeTraverser_ComponentTreePath((ImmutableList<BindingGraph>)ImmutableList.copyOf(path));
        }

        public abstract ImmutableList<BindingGraph> graphsInPath();

        public BindingGraph currentGraph() {
            return (BindingGraph)Iterables.getLast(this.graphsInPath());
        }

        public TypeElement currentComponent() {
            return this.currentGraph().componentDescriptor().componentDefinitionType();
        }

        public BindingGraph parentGraph() {
            Preconditions.checkState((!this.atRoot() ? 1 : 0) != 0);
            return (BindingGraph)this.graphsInPath().reverse().get(1);
        }

        public BindingGraph rootGraph() {
            return (BindingGraph)this.graphsInPath().get(0);
        }

        public boolean atRoot() {
            return this.graphsInPath().size() == 1;
        }

        public BindingGraph rootmostGraph(Iterable<ComponentDescriptor> components) {
            ImmutableSet set = ImmutableSet.copyOf(components);
            return this.rootmostGraph((? super BindingGraph graph) -> set.contains((Object)graph.componentDescriptor()));
        }

        public BindingGraph graphForComponent(ComponentDescriptor component) {
            Preconditions.checkNotNull((Object)component);
            return this.rootmostGraph((? super BindingGraph graph) -> graph.componentDescriptor().equals(component));
        }

        ComponentTreePath pathFromRootToAncestor(ComponentDescriptor ancestor) {
            Preconditions.checkNotNull((Object)ancestor);
            ImmutableList.Builder path = ImmutableList.builder();
            for (BindingGraph graph : this.graphsInPath()) {
                path.add((Object)graph);
                if (!graph.componentDescriptor().equals(ancestor)) continue;
                return ComponentTreePath.create((Iterable<BindingGraph>)path.build());
            }
            throw new IllegalArgumentException(String.format("%s is not in the current path: %s", ancestor.componentDefinitionType().getQualifiedName(), this));
        }

        ComponentTreePath childPath(TypeElement subcomponent) {
            for (BindingGraph child : this.currentGraph().subgraphs()) {
                if (!child.componentType().equals(subcomponent)) continue;
                return ComponentTreePath.create((Iterable<BindingGraph>)FluentIterable.from(this.graphsInPath()).append((Object[])new BindingGraph[]{child}));
            }
            throw new IllegalArgumentException(String.format("%s is not a child of %s", subcomponent.getQualifiedName(), this.currentGraph().componentType().getQualifiedName()));
        }

        private BindingGraph rootmostGraph(Predicate<? super BindingGraph> predicate) {
            return this.graphsInPath().stream().filter(predicate).findFirst().get();
        }

        public String toString() {
            return this.graphsInPath().stream().map(BindingGraph::componentType).map(TypeElement::getQualifiedName).collect(Collectors.joining(" \u2192 "));
        }
    }

    private static final class NoOpBindingGraphTraverser
    extends BindingGraphTraverser {
        private NoOpBindingGraphTraverser(ComponentTreePath componentPath, DependencyRequest entryPoint) {
            super(componentPath, entryPoint);
        }

        @Override
        public void traverseDependencies() {
        }
    }

    public static class BindingGraphTraverser {
        private final ComponentTreePath componentTreePath;
        private final DependencyRequest entryPoint;
        private final Deque<DependencyRequest> dependencyRequestPath = new ArrayDeque<DependencyRequest>();
        private final Deque<ResolvedBindings> resolvedBindingsPath = new ArrayDeque<ResolvedBindings>();
        private final LinkedHashMultiset<BindingKey> bindingKeysInPath = LinkedHashMultiset.create();
        private final Set<DependencyRequest> visitedDependencyRequests = new HashSet<DependencyRequest>();

        public BindingGraphTraverser(ComponentTreePath componentPath, DependencyRequest entryPoint) {
            this.componentTreePath = componentPath;
            this.entryPoint = entryPoint;
        }

        public void traverseDependencies() {
            Preconditions.checkState((boolean)this.dependencyRequestPath.isEmpty());
            Preconditions.checkState((boolean)this.resolvedBindingsPath.isEmpty());
            Preconditions.checkState((boolean)this.bindingKeysInPath.isEmpty());
            Preconditions.checkState((boolean)this.visitedDependencyRequests.isEmpty());
            this.nextDependencyRequest(this.entryPoint, this.currentGraph());
        }

        protected void visitDependencyRequest(DependencyRequest dependencyRequest) {
            if (!this.atDependencyCycle()) {
                this.visitResolvedBindings(this.resolvedBindingsPath.getLast());
            }
        }

        protected void visitResolvedBindings(ResolvedBindings resolvedBindings) {
            switch (resolvedBindings.bindingKey().kind()) {
                case MEMBERS_INJECTION: {
                    this.visitMembersInjectionBindings(resolvedBindings);
                    break;
                }
                case CONTRIBUTION: {
                    this.visitContributionBindings(resolvedBindings);
                }
            }
        }

        protected void visitMembersInjectionBindings(ResolvedBindings resolvedBindings) {
            if (!resolvedBindings.contributionBindings().isEmpty()) {
                throw new AssertionError((Object)"members injection binding keys should never have contribution bindings");
            }
            if (resolvedBindings.membersInjectionBinding().isPresent()) {
                this.visitMembersInjectionBinding(resolvedBindings.membersInjectionBinding().get(), (ComponentDescriptor)Iterables.getOnlyElement((Iterable)resolvedBindings.allMembersInjectionBindings().keySet()));
            }
        }

        protected void visitMembersInjectionBinding(MembersInjectionBinding binding, ComponentDescriptor owningComponent) {
            this.visitBinding(binding, owningComponent);
        }

        protected void visitContributionBindings(ResolvedBindings resolvedBindings) {
            if (resolvedBindings.membersInjectionBinding().isPresent()) {
                throw new AssertionError((Object)"contribution binding keys should never have members injection bindings");
            }
            Multimaps.asMap(resolvedBindings.allContributionBindings()).forEach((owningComponent, bindings) -> bindings.forEach(binding -> this.visitContributionBinding((ContributionBinding)binding, (ComponentDescriptor)owningComponent)));
        }

        protected void visitContributionBinding(ContributionBinding binding, ComponentDescriptor owningComponent) {
            this.visitBinding(binding, owningComponent);
        }

        protected void visitBinding(Binding binding, ComponentDescriptor owningComponent) {
            BindingGraph owningGraph = this.componentTreePath.graphForComponent(owningComponent);
            for (DependencyRequest dependency : binding.dependencies()) {
                this.nextDependencyRequest(dependency, owningGraph);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void nextDependencyRequest(DependencyRequest dependencyRequest, BindingGraph bindingGraph) {
            if (!this.visitedDependencyRequests.add(dependencyRequest)) {
                return;
            }
            ResolvedBindings resolvedBindings = (ResolvedBindings)bindingGraph.resolvedBindings().get((Object)dependencyRequest.bindingKey());
            this.dependencyRequestPath.addLast(dependencyRequest);
            this.resolvedBindingsPath.addLast(resolvedBindings);
            this.bindingKeysInPath.add((Object)dependencyRequest.bindingKey());
            try {
                this.visitDependencyRequest(dependencyRequest);
            }
            finally {
                Verify.verify((boolean)this.dependencyRequestPath.removeLast().equals(dependencyRequest));
                Verify.verify((boolean)this.resolvedBindingsPath.removeLast().equals(resolvedBindings));
                Verify.verify((boolean)this.bindingKeysInPath.remove((Object)dependencyRequest.bindingKey()));
            }
        }

        protected final ComponentTreePath componentTreePath() {
            return this.componentTreePath;
        }

        public BindingGraph owningGraph(Iterable<ContributionBinding> bindings) {
            ImmutableSet.Builder owningComponents = ImmutableSet.builder();
            for (ContributionBinding binding : bindings) {
                ResolvedBindings resolvedBindings = (ResolvedBindings)this.currentGraph().resolvedBindings().get((Object)BindingKey.contribution(binding.key()));
                owningComponents.add((Object)resolvedBindings.owningComponent(binding));
            }
            return this.componentTreePath.rootmostGraph((Iterable<ComponentDescriptor>)owningComponents.build());
        }

        protected final boolean atDependencyCycle() {
            Preconditions.checkState((!this.dependencyRequestPath.isEmpty() ? 1 : 0) != 0);
            return this.bindingKeysInPath.count((Object)this.dependencyRequest().bindingKey()) > 1;
        }

        protected final DependencyRequest dependencyRequest() {
            return this.dependencyRequestPath.getLast();
        }

        protected final ResolvedBindings resolvedBindings() {
            return this.resolvedBindingsPath.getLast();
        }

        protected final ImmutableSet<? extends Binding> dependentBindings() {
            if (this.atEntryPoint()) {
                return ImmutableSet.of();
            }
            ResolvedBindings dependentResolvedBindings = (ResolvedBindings)Iterators.get(this.resolvedBindingsPath.descendingIterator(), (int)1);
            return dependentResolvedBindings.bindings().stream().filter(binding -> binding.dependencies().contains((Object)this.dependencyRequest())).collect(DaggerStreams.toImmutableSet());
        }

        protected final Element entryPointElement() {
            return this.entryPoint.requestElement().get();
        }

        protected final boolean atEntryPoint() {
            return this.dependencyRequestPath.size() == 1;
        }

        protected final BindingGraph currentGraph() {
            return this.componentTreePath.currentGraph();
        }

        protected final DependencyTrace dependencyTrace() {
            Preconditions.checkState((!this.dependencyRequestPath.isEmpty() ? 1 : 0) != 0);
            return new DependencyTrace(this.dependencyRequestPath, this.resolvedBindingsPath);
        }

        protected final DependencyTrace cycleDependencyTrace() {
            Preconditions.checkState((boolean)this.atDependencyCycle(), (Object)"no cycle");
            int skip = Iterables.indexOf(this.bindingKeysInPath, (com.google.common.base.Predicate)Predicates.equalTo((Object)this.dependencyRequest().bindingKey()));
            return new DependencyTrace(Iterables.skip(this.dependencyRequestPath, (int)skip), Iterables.skip(this.resolvedBindingsPath, (int)skip));
        }
    }
}

