/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentWriter;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

final class ComponentGenerator
extends SourceFileGenerator<BindingGraph> {
    private final DaggerTypes types;
    private final Elements elements;
    private final KeyFactory keyFactory;
    private final CompilerOptions compilerOptions;

    ComponentGenerator(Filer filer, Elements elements, DaggerTypes types, KeyFactory keyFactory, CompilerOptions compilerOptions) {
        super(filer, elements);
        this.types = types;
        this.elements = elements;
        this.keyFactory = keyFactory;
        this.compilerOptions = compilerOptions;
    }

    @Override
    ClassName nameGeneratedType(BindingGraph input) {
        return ComponentGenerator.componentName(input.componentType());
    }

    static ClassName componentName(TypeElement componentDefinitionType) {
        ClassName componentName = ClassName.get((TypeElement)componentDefinitionType);
        return ClassName.get((String)componentName.packageName(), (String)("Dagger" + SourceFiles.classFileName(componentName)), (String[])new String[0]);
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(BindingGraph input) {
        return Optional.of(input.componentType());
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName componentName, BindingGraph input) {
        return Optional.of(ComponentWriter.write(this.types, this.elements, this.keyFactory, this.compilerOptions, componentName, input));
    }
}

