/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.AnnotationCreatorGenerator;
import dagger.internal.codegen.CanReleaseReferencesValidator;
import dagger.internal.codegen.ValidationReport;
import dagger.releasablereferences.CanReleaseReferences;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Scope;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class CanReleaseReferencesProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final CanReleaseReferencesValidator canReleaseReferencesValidator;
    private final AnnotationCreatorGenerator annotationCreatorGenerator;

    CanReleaseReferencesProcessingStep(Messager messager, CanReleaseReferencesValidator canReleaseReferencesValidator, AnnotationCreatorGenerator annotationCreatorGenerator) {
        this.messager = messager;
        this.canReleaseReferencesValidator = canReleaseReferencesValidator;
        this.annotationCreatorGenerator = annotationCreatorGenerator;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(CanReleaseReferences.class);
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        for (TypeElement annotatedElement : ElementFilter.typesIn(elementsByAnnotation.get(CanReleaseReferences.class))) {
            ValidationReport<TypeElement> report = this.canReleaseReferencesValidator.validate(annotatedElement);
            report.printMessagesTo(this.messager);
            if (!report.isClean() || MoreElements.isAnnotationPresent(annotatedElement, Scope.class)) continue;
            this.annotationCreatorGenerator.generate(annotatedElement, this.messager);
        }
        return ImmutableSet.of();
    }
}

