/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.DependencyRequest;
import dagger.model.RequestKind;

enum BindingTypeMapper {
    FOR_PROVIDER{

        @Override
        public BindingType getBindingType(RequestKind requestKind) {
            switch (requestKind) {
                case INSTANCE: 
                case PROVIDER: 
                case PROVIDER_OF_LAZY: 
                case LAZY: {
                    return BindingType.PROVISION;
                }
                case MEMBERS_INJECTOR: {
                    return BindingType.MEMBERS_INJECTION;
                }
                case PRODUCED: 
                case PRODUCER: {
                    throw new IllegalArgumentException(requestKind.toString());
                }
            }
            throw new AssertionError(requestKind);
        }
    }
    ,
    FOR_PRODUCER{

        @Override
        public BindingType getBindingType(RequestKind requestKind) {
            switch (requestKind) {
                case INSTANCE: 
                case PRODUCED: 
                case PRODUCER: {
                    return BindingType.PRODUCTION;
                }
                case PROVIDER: 
                case PROVIDER_OF_LAZY: 
                case LAZY: {
                    return BindingType.PROVISION;
                }
                case MEMBERS_INJECTOR: {
                    return BindingType.MEMBERS_INJECTION;
                }
            }
            throw new AssertionError(requestKind);
        }
    };


    static BindingTypeMapper forBindingType(BindingType bindingType) {
        return bindingType.equals((Object)BindingType.PRODUCTION) ? FOR_PRODUCER : FOR_PROVIDER;
    }

    abstract BindingType getBindingType(RequestKind var1);

    BindingType getBindingType(Iterable<DependencyRequest> requests) {
        ImmutableSet classes = FluentIterable.from(requests).transform(request -> this.getBindingType(request.kind())).toSet();
        if (classes.size() == 1) {
            return (BindingType)((Object)Iterables.getOnlyElement((Iterable)classes));
        }
        if (classes.equals(BindingType.CONTRIBUTION_TYPES)) {
            return BindingType.PROVISION;
        }
        throw new IllegalArgumentException("Bad set of framework classes: " + classes);
    }
}

