/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.AutoValue_ProductionBinding;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.Util;
import dagger.producers.Producer;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

abstract class ProductionBinding
extends ContributionBinding {
    ProductionBinding() {
    }

    @Override
    public BindingType bindingType() {
        return BindingType.PRODUCTION;
    }

    Optional<ProductionBinding> unresolved() {
        return Optional.empty();
    }

    ImmutableSet<DependencyRequest> implicitDependencies() {
        return Stream.of(this.executorRequest(), this.monitorRequest()).filter(Optional::isPresent).map(Optional::get).collect(Util.toImmutableSet());
    }

    abstract Optional<ProductionKind> productionKind();

    abstract ImmutableList<? extends TypeMirror> thrownTypes();

    abstract Optional<DependencyRequest> executorRequest();

    abstract Optional<DependencyRequest> monitorRequest();

    private static Builder builder() {
        return ((Builder)new AutoValue_ProductionBinding.Builder().explicitDependencies((Iterable)ImmutableList.of())).thrownTypes((Iterable<? extends TypeMirror>)ImmutableList.of());
    }

    static final class Factory {
        private final Types types;
        private final Key.Factory keyFactory;
        private final DependencyRequest.Factory dependencyRequestFactory;

        Factory(Types types, Key.Factory keyFactory, DependencyRequest.Factory dependencyRequestFactory) {
            this.types = types;
            this.keyFactory = keyFactory;
            this.dependencyRequestFactory = dependencyRequestFactory;
        }

        ProductionBinding forProducesMethod(ExecutableElement producesMethod, TypeElement contributedBy) {
            Preconditions.checkArgument((boolean)producesMethod.getKind().equals((Object)ElementKind.METHOD));
            ContributionType contributionType = ContributionType.fromBindingMethod(producesMethod);
            Key key = this.keyFactory.forProducesMethod(producesMethod, contributedBy);
            ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(contributedBy.asType()), producesMethod));
            ImmutableSet<DependencyRequest> dependencies = this.dependencyRequestFactory.forRequiredResolvedVariables(producesMethod.getParameters(), resolvedMethod.getParameterTypes());
            DependencyRequest executorRequest = this.dependencyRequestFactory.forProductionImplementationExecutor();
            DependencyRequest monitorRequest = this.dependencyRequestFactory.forProductionComponentMonitor();
            ProductionKind productionKind = MoreTypes.isTypeOf(ListenableFuture.class, producesMethod.getReturnType()) ? ProductionKind.FUTURE : (contributionType.equals((Object)ContributionType.SET_VALUES) && SetType.from(producesMethod.getReturnType()).elementsAreTypeOf(ListenableFuture.class) ? ProductionKind.SET_OF_FUTURE : ProductionKind.IMMEDIATE);
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ProductionBinding.builder().contributionType(contributionType)).bindingElement(producesMethod)).contributingModule(contributedBy)).key(key)).explicitDependencies((Iterable<DependencyRequest>)dependencies)).wrappedMapKey(MoreAnnotationMirrors.wrapOptionalInEquivalence(MapKeys.getMapKey(producesMethod)))).bindingKind(ContributionBinding.Kind.PRODUCTION)).productionKind(productionKind).thrownTypes(producesMethod.getThrownTypes()).executorRequest(executorRequest).monitorRequest(monitorRequest).build();
        }

        ProductionBinding syntheticMapOfValuesOrProducedBinding(Key mapOfValuesOrProducedKey) {
            Preconditions.checkNotNull((Object)mapOfValuesOrProducedKey);
            Optional<Key> mapOfProducersKey = this.keyFactory.implicitMapProducerKeyFrom(mapOfValuesOrProducedKey);
            Preconditions.checkArgument((boolean)mapOfProducersKey.isPresent(), (String)"%s is not a key for of Map<K, V> or Map<K, Produced<V>>", (Object)mapOfValuesOrProducedKey);
            DependencyRequest requestForMapOfProducers = this.dependencyRequestFactory.producerForImplicitMapBinding(mapOfProducersKey.get());
            return ((Builder)((Builder)((Builder)((Builder)ProductionBinding.builder().contributionType(ContributionType.UNIQUE)).key(mapOfValuesOrProducedKey)).explicitDependencies(requestForMapOfProducers)).bindingKind(ContributionBinding.Kind.SYNTHETIC_MAP)).build();
        }

        ProductionBinding syntheticMultibinding(Key key, Iterable<ContributionBinding> multibindingContributions) {
            return ((Builder)((Builder)((Builder)((Builder)ProductionBinding.builder().contributionType(ContributionType.UNIQUE)).key(key)).explicitDependencies((Iterable<DependencyRequest>)this.dependencyRequestFactory.forMultibindingContributions(multibindingContributions))).bindingKind(ContributionBinding.Kind.forMultibindingKey(key))).build();
        }

        ProductionBinding forComponentMethod(ExecutableElement componentMethod) {
            Preconditions.checkNotNull((Object)componentMethod);
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            Preconditions.checkArgument((boolean)componentMethod.getParameters().isEmpty());
            Preconditions.checkArgument((boolean)MoreTypes.isTypeOf(ListenableFuture.class, componentMethod.getReturnType()));
            return ((Builder)((Builder)((Builder)((Builder)ProductionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(componentMethod)).key(this.keyFactory.forProductionComponentMethod(componentMethod))).bindingKind(ContributionBinding.Kind.COMPONENT_PRODUCTION)).thrownTypes(componentMethod.getThrownTypes()).build();
        }

        ProductionBinding delegate(DelegateDeclaration delegateDeclaration, ProductionBinding delegateBinding) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ProductionBinding.builder().contributionType(delegateDeclaration.contributionType())).bindingElement(delegateDeclaration.bindingElement().get())).contributingModule(delegateDeclaration.contributingModule().get())).key(this.keyFactory.forDelegateBinding(delegateDeclaration, Producer.class))).explicitDependencies(delegateDeclaration.delegateRequest())).nullableType(delegateBinding.nullableType())).wrappedMapKey(delegateDeclaration.wrappedMapKey())).bindingKind(ContributionBinding.Kind.SYNTHETIC_DELEGATE_BINDING)).build();
        }

        ProductionBinding syntheticPresentBinding(Key key) {
            return ((Builder)((Builder)((Builder)((Builder)ProductionBinding.builder().contributionType(ContributionType.UNIQUE)).key(key)).bindingKind(ContributionBinding.Kind.SYNTHETIC_OPTIONAL_BINDING)).explicitDependencies(this.dependencyRequestFactory.forSyntheticPresentOptionalBinding(key, DependencyRequest.Kind.PRODUCER))).build();
        }
    }

    @CanIgnoreReturnValue
    static abstract class Builder
    extends ContributionBinding.Builder<Builder> {
        Builder() {
        }

        abstract Builder productionKind(ProductionKind var1);

        abstract Builder thrownTypes(Iterable<? extends TypeMirror> var1);

        abstract Builder executorRequest(DependencyRequest var1);

        abstract Builder monitorRequest(DependencyRequest var1);

        @CheckReturnValue
        abstract ProductionBinding build();
    }

    static enum ProductionKind {
        IMMEDIATE,
        FUTURE,
        SET_OF_FUTURE;

    }
}

