/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.FactoryGenerator;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.ProducerFactoryGenerator;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class ModuleProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final Class<? extends Annotation> moduleAnnotation;
    private final ModuleValidator moduleValidator;
    private final ImmutableSet<ModuleMethodFactoryGenerator> moduleMethodFactoryGenerators;
    private final Set<TypeElement> processedModuleElements = Sets.newLinkedHashSet();

    static ModuleProcessingStep moduleProcessingStep(Messager messager, ModuleValidator moduleValidator, ProvisionBinding.Factory provisionBindingFactory, FactoryGenerator factoryGenerator) {
        return new ModuleProcessingStep(messager, Module.class, moduleValidator, (ImmutableSet<ModuleMethodFactoryGenerator>)ImmutableSet.of((Object)new ProvisionModuleMethodFactoryGenerator(provisionBindingFactory, factoryGenerator)));
    }

    static ModuleProcessingStep producerModuleProcessingStep(Messager messager, ModuleValidator moduleValidator, ProvisionBinding.Factory provisionBindingFactory, FactoryGenerator factoryGenerator, ProductionBinding.Factory productionBindingFactory, ProducerFactoryGenerator producerFactoryGenerator) {
        return new ModuleProcessingStep(messager, ProducerModule.class, moduleValidator, (ImmutableSet<ModuleMethodFactoryGenerator>)ImmutableSet.of((Object)new ProvisionModuleMethodFactoryGenerator(provisionBindingFactory, factoryGenerator), (Object)new ProductionModuleMethodFactoryGenerator(productionBindingFactory, producerFactoryGenerator)));
    }

    ModuleProcessingStep(Messager messager, Class<? extends Annotation> moduleAnnotation, ModuleValidator moduleValidator, ImmutableSet<ModuleMethodFactoryGenerator> moduleMethodFactoryGenerators) {
        this.messager = messager;
        this.moduleAnnotation = moduleAnnotation;
        this.moduleValidator = moduleValidator;
        this.moduleMethodFactoryGenerators = moduleMethodFactoryGenerators;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(this.moduleAnnotation);
    }

    @Override
    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        List<TypeElement> modules = ElementFilter.typesIn(elementsByAnnotation.values());
        this.moduleValidator.addKnownModules(modules);
        for (TypeElement module : modules) {
            if (!this.processedModuleElements.add(module)) continue;
            this.processModule(module);
        }
        return ImmutableSet.of();
    }

    private void processModule(TypeElement module) {
        ValidationReport<TypeElement> report = this.moduleValidator.validate(module);
        report.printMessagesTo(this.messager);
        if (report.isClean()) {
            for (ExecutableElement method : ElementFilter.methodsIn(module.getEnclosedElements())) {
                for (ModuleMethodFactoryGenerator generator : this.moduleMethodFactoryGenerators) {
                    if (!MoreElements.isAnnotationPresent(method, generator.factoryMethodAnnotation())) continue;
                    generator.generate(method, module, this.messager);
                }
            }
        }
    }

    private static final class ProductionModuleMethodFactoryGenerator
    implements ModuleMethodFactoryGenerator {
        private final ProductionBinding.Factory productionBindingFactory;
        private final ProducerFactoryGenerator producerFactoryGenerator;

        ProductionModuleMethodFactoryGenerator(ProductionBinding.Factory productionBindingFactory, ProducerFactoryGenerator productionFactoryGenerator) {
            this.productionBindingFactory = productionBindingFactory;
            this.producerFactoryGenerator = productionFactoryGenerator;
        }

        @Override
        public Class<? extends Annotation> factoryMethodAnnotation() {
            return Produces.class;
        }

        @Override
        public void generate(ExecutableElement method, TypeElement moduleElement, Messager messager) {
            this.producerFactoryGenerator.generate(this.productionBindingFactory.forProducesMethod(method, moduleElement), messager);
        }
    }

    private static final class ProvisionModuleMethodFactoryGenerator
    implements ModuleMethodFactoryGenerator {
        private final ProvisionBinding.Factory provisionBindingFactory;
        private final FactoryGenerator factoryGenerator;

        ProvisionModuleMethodFactoryGenerator(ProvisionBinding.Factory provisionBindingFactory, FactoryGenerator factoryGenerator) {
            this.provisionBindingFactory = provisionBindingFactory;
            this.factoryGenerator = factoryGenerator;
        }

        @Override
        public Class<? extends Annotation> factoryMethodAnnotation() {
            return Provides.class;
        }

        @Override
        public void generate(ExecutableElement method, TypeElement moduleElement, Messager messager) {
            this.factoryGenerator.generate(this.provisionBindingFactory.forProvidesMethod(method, moduleElement), messager);
        }
    }

    static interface ModuleMethodFactoryGenerator {
        public Class<? extends Annotation> factoryMethodAnnotation();

        public void generate(ExecutableElement var1, TypeElement var2, Messager var3);
    }
}

