/*
 * Decompiled with CFR 0.152.
 */
package dagger.android;

import android.app.Application;
import com.google.errorprone.annotations.ForOverride;
import dagger.android.AndroidInjector;
import dagger.android.DispatchingAndroidInjector;
import dagger.android.HasAndroidInjector;
import javax.inject.Inject;

public abstract class DaggerApplication
extends Application
implements HasAndroidInjector {
    @Inject
    volatile DispatchingAndroidInjector<Object> androidInjector;

    public void onCreate() {
        super.onCreate();
        this.injectIfNecessary();
    }

    @ForOverride
    protected abstract AndroidInjector<? extends DaggerApplication> applicationInjector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectIfNecessary() {
        if (this.androidInjector == null) {
            DaggerApplication daggerApplication = this;
            synchronized (daggerApplication) {
                if (this.androidInjector == null) {
                    AndroidInjector<? extends DaggerApplication> applicationInjector = this.applicationInjector();
                    applicationInjector.inject(this);
                    if (this.androidInjector == null) {
                        throw new IllegalStateException("The AndroidInjector returned from applicationInjector() did not inject the DaggerApplication");
                    }
                }
            }
        }
    }

    @Override
    public AndroidInjector<Object> androidInjector() {
        this.injectIfNecessary();
        return this.androidInjector;
    }
}

