/*
 * Decompiled with CFR 0.152.
 */
package dagger.android;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.android.AndroidInjector;
import dagger.internal.DaggerCollections;
import dagger.internal.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public final class DispatchingAndroidInjector<T>
implements AndroidInjector<T> {
    private static final String NO_SUPERTYPES_BOUND_FORMAT = "No injector factory bound for Class<%s>";
    private static final String SUPERTYPES_BOUND_FORMAT = "No injector factory bound for Class<%1$s>. Injector factories were bound for supertypes of %1$s: %2$s. Did you mean to bind an injector factory for the subtype?";
    private final Map<String, Provider<AndroidInjector.Factory<?>>> injectorFactories;

    @Inject
    DispatchingAndroidInjector(Map<Class<?>, Provider<AndroidInjector.Factory<?>>> injectorFactoriesWithClassKeys, Map<String, Provider<AndroidInjector.Factory<?>>> injectorFactoriesWithStringKeys, Map<Class<? extends T>, Provider<AndroidInjector.Factory<? extends T>>> boundedInjectorFactoriesWithClassKeys, Map<String, Provider<AndroidInjector.Factory<? extends T>>> boundedInjectorFactoriesWithStringKeys) {
        this.injectorFactories = DispatchingAndroidInjector.secondaryMerge(DispatchingAndroidInjector.merge(injectorFactoriesWithClassKeys, injectorFactoriesWithStringKeys), DispatchingAndroidInjector.merge(boundedInjectorFactoriesWithClassKeys, boundedInjectorFactoriesWithStringKeys));
    }

    private static <C, V> Map<String, Provider<AndroidInjector.Factory<?>>> merge(Map<Class<? extends C>, V> classKeyedMap, Map<String, V> stringKeyedMap) {
        if (classKeyedMap.isEmpty()) {
            Map<String, Provider<AndroidInjector.Factory<?>>> safeCast = stringKeyedMap;
            return safeCast;
        }
        LinkedHashMap merged = DaggerCollections.newLinkedHashMapWithExpectedSize((int)(classKeyedMap.size() + stringKeyedMap.size()));
        merged.putAll(stringKeyedMap);
        for (Map.Entry<Class<C>, V> entry : classKeyedMap.entrySet()) {
            merged.put(entry.getKey().getName(), entry.getValue());
        }
        LinkedHashMap safeCast = merged;
        return Collections.unmodifiableMap(safeCast);
    }

    private static <K, V> Map<K, V> secondaryMerge(Map<K, V> firstMap, Map<K, V> secondMap) {
        if (firstMap.isEmpty()) {
            return secondMap;
        }
        if (secondMap.isEmpty()) {
            return firstMap;
        }
        LinkedHashMap merged = DaggerCollections.newLinkedHashMapWithExpectedSize((int)(firstMap.size() + secondMap.size()));
        merged.putAll(firstMap);
        merged.putAll(secondMap);
        return merged;
    }

    @CanIgnoreReturnValue
    public boolean maybeInject(T instance) {
        Provider<AndroidInjector.Factory<?>> factoryProvider = this.injectorFactories.get(instance.getClass().getName());
        if (factoryProvider == null) {
            return false;
        }
        AndroidInjector.Factory factory = (AndroidInjector.Factory)factoryProvider.get();
        try {
            AndroidInjector injector = (AndroidInjector)Preconditions.checkNotNull(factory.create(instance), (String)"%s.create(I) should not return null.", factory.getClass());
            injector.inject(instance);
            return true;
        }
        catch (ClassCastException e) {
            throw new InvalidInjectorBindingException(String.format("%s does not implement AndroidInjector.Factory<%s>", factory.getClass().getCanonicalName(), instance.getClass().getCanonicalName()), e);
        }
    }

    @Override
    public void inject(T instance) {
        boolean wasInjected = this.maybeInject(instance);
        if (!wasInjected) {
            throw new IllegalArgumentException(this.errorMessageSuggestions(instance));
        }
    }

    private String errorMessageSuggestions(T instance) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!this.injectorFactories.containsKey(clazz.getCanonicalName())) continue;
            suggestions.add(clazz.getCanonicalName());
        }
        return suggestions.isEmpty() ? String.format(NO_SUPERTYPES_BOUND_FORMAT, instance.getClass().getCanonicalName()) : String.format(SUPERTYPES_BOUND_FORMAT, instance.getClass().getCanonicalName(), suggestions);
    }

    public static final class InvalidInjectorBindingException
    extends RuntimeException {
        InvalidInjectorBindingException(String message, ClassCastException cause) {
            super(message, cause);
        }
    }
}

