/*
 * Decompiled with CFR 0.152.
 */
package dagger.android;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ContentProvider;
import android.content.Context;
import android.util.Log;
import dagger.android.AndroidInjector;
import dagger.android.HasActivityInjector;
import dagger.android.HasBroadcastReceiverInjector;
import dagger.android.HasContentProviderInjector;
import dagger.android.HasFragmentInjector;
import dagger.android.HasServiceInjector;
import dagger.internal.Preconditions;

public final class AndroidInjection {
    private static final String TAG = "dagger.android";

    public static void inject(Activity activity) {
        Preconditions.checkNotNull((Object)activity, (String)"activity");
        Application application = activity.getApplication();
        if (!(application instanceof HasActivityInjector)) {
            throw new RuntimeException(String.format("%s does not implement %s", application.getClass().getCanonicalName(), HasActivityInjector.class.getCanonicalName()));
        }
        AndroidInjector<Activity> activityInjector = ((HasActivityInjector)application).activityInjector();
        Preconditions.checkNotNull(activityInjector, (String)"%s.activityInjector() returned null", application.getClass());
        activityInjector.inject(activity);
    }

    public static void inject(Fragment fragment) {
        Preconditions.checkNotNull((Object)fragment, (String)"fragment");
        HasFragmentInjector hasFragmentInjector = AndroidInjection.findHasFragmentInjector(fragment);
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)String.format("An injector for %s was found in %s", fragment.getClass().getCanonicalName(), hasFragmentInjector.getClass().getCanonicalName()));
        }
        AndroidInjector<Fragment> fragmentInjector = hasFragmentInjector.fragmentInjector();
        Preconditions.checkNotNull(fragmentInjector, (String)"%s.fragmentInjector() returned null", hasFragmentInjector.getClass());
        fragmentInjector.inject(fragment);
    }

    private static HasFragmentInjector findHasFragmentInjector(Fragment fragment) {
        Fragment parentFragment = fragment;
        while ((parentFragment = parentFragment.getParentFragment()) != null) {
            if (!(parentFragment instanceof HasFragmentInjector)) continue;
            return (HasFragmentInjector)parentFragment;
        }
        Activity activity = fragment.getActivity();
        if (activity instanceof HasFragmentInjector) {
            return (HasFragmentInjector)activity;
        }
        if (activity.getApplication() instanceof HasFragmentInjector) {
            return (HasFragmentInjector)activity.getApplication();
        }
        throw new IllegalArgumentException(String.format("No injector was found for %s", fragment.getClass().getCanonicalName()));
    }

    public static void inject(Service service) {
        Preconditions.checkNotNull((Object)service, (String)"service");
        Application application = service.getApplication();
        if (!(application instanceof HasServiceInjector)) {
            throw new RuntimeException(String.format("%s does not implement %s", application.getClass().getCanonicalName(), HasServiceInjector.class.getCanonicalName()));
        }
        AndroidInjector<Service> serviceInjector = ((HasServiceInjector)application).serviceInjector();
        Preconditions.checkNotNull(serviceInjector, (String)"%s.serviceInjector() returned null", application.getClass());
        serviceInjector.inject(service);
    }

    public static void inject(BroadcastReceiver broadcastReceiver, Context context) {
        Preconditions.checkNotNull((Object)broadcastReceiver, (String)"broadcastReceiver");
        Preconditions.checkNotNull((Object)context, (String)"context");
        Application application = (Application)context.getApplicationContext();
        if (!(application instanceof HasBroadcastReceiverInjector)) {
            throw new RuntimeException(String.format("%s does not implement %s", application.getClass().getCanonicalName(), HasBroadcastReceiverInjector.class.getCanonicalName()));
        }
        AndroidInjector<BroadcastReceiver> broadcastReceiverInjector = ((HasBroadcastReceiverInjector)application).broadcastReceiverInjector();
        Preconditions.checkNotNull(broadcastReceiverInjector, (String)"%s.broadcastReceiverInjector() returned null", application.getClass());
        broadcastReceiverInjector.inject(broadcastReceiver);
    }

    public static void inject(ContentProvider contentProvider) {
        Preconditions.checkNotNull((Object)contentProvider, (String)"contentProvider");
        Application application = (Application)contentProvider.getContext().getApplicationContext();
        if (!(application instanceof HasContentProviderInjector)) {
            throw new RuntimeException(String.format("%s does not implement %s", application.getClass().getCanonicalName(), HasContentProviderInjector.class.getCanonicalName()));
        }
        AndroidInjector<ContentProvider> contentProviderInjector = ((HasContentProviderInjector)application).contentProviderInjector();
        Preconditions.checkNotNull(contentProviderInjector, (String)"%s.contentProviderInjector() returned null", application.getClass());
        contentProviderInjector.inject(contentProvider);
    }

    private AndroidInjection() {
    }
}

