/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.support;

import android.app.Application;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import dagger.android.AndroidInjector;
import dagger.android.HasAndroidInjector;
import dagger.android.support.HasSupportFragmentInjector;
import dagger.internal.Preconditions;

public final class AndroidSupportInjection {
    private static final String TAG = "dagger.android.support";

    public static void inject(Fragment fragment) {
        AndroidInjector<Fragment> injector;
        Preconditions.checkNotNull((Object)fragment, (String)"fragment");
        Object hasInjector = AndroidSupportInjection.findHasSupportFragmentInjector(fragment);
        if (hasInjector instanceof HasAndroidInjector) {
            injector = ((HasAndroidInjector)hasInjector).androidInjector();
            Preconditions.checkNotNull(injector, (String)"%s.androidInjector() returned null", hasInjector.getClass());
        } else if (hasInjector instanceof HasSupportFragmentInjector) {
            injector = ((HasSupportFragmentInjector)hasInjector).supportFragmentInjector();
            Preconditions.checkNotNull(injector, (String)"%s.supportFragmentInjector() returned null", hasInjector.getClass());
        } else {
            throw new RuntimeException(String.format("%s does not implement %s or %s", hasInjector.getClass().getCanonicalName(), HasAndroidInjector.class.getCanonicalName(), HasSupportFragmentInjector.class.getCanonicalName()));
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)String.format("An injector for %s was found in %s", fragment.getClass().getCanonicalName(), hasInjector.getClass().getCanonicalName()));
        }
        injector.inject((Object)fragment);
    }

    private static Object findHasSupportFragmentInjector(Fragment fragment) {
        Fragment parentFragment = fragment;
        while ((parentFragment = parentFragment.getParentFragment()) != null) {
            if (!(parentFragment instanceof HasAndroidInjector) && !(parentFragment instanceof HasSupportFragmentInjector)) continue;
            return parentFragment;
        }
        FragmentActivity activity = fragment.getActivity();
        if (activity instanceof HasAndroidInjector || activity instanceof HasSupportFragmentInjector) {
            return activity;
        }
        Application application = activity.getApplication();
        if (application instanceof HasAndroidInjector || application instanceof HasSupportFragmentInjector) {
            return application;
        }
        throw new IllegalArgumentException(String.format("No injector was found for %s", fragment.getClass().getCanonicalName()));
    }

    private AndroidSupportInjection() {
    }
}

