/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.support;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import dagger.android.DispatchingAndroidInjector;
import dagger.android.support.HasDispatchingSupportFragmentInjector;
import dagger.internal.Preconditions;

public final class AndroidSupportInjection {
    private static final String TAG = "dagger.android.support";

    public static void inject(Fragment fragment) {
        Preconditions.checkNotNull((Object)fragment, (String)"fragment");
        HasDispatchingSupportFragmentInjector hasDispatchingSupportFragmentInjector = AndroidSupportInjection.findHasFragmentInjector(fragment);
        Log.d((String)TAG, (String)String.format("An injector for %s was found in %s", fragment.getClass().getCanonicalName(), hasDispatchingSupportFragmentInjector.getClass().getCanonicalName()));
        DispatchingAndroidInjector<Fragment> dispatchingAndroidInjector = hasDispatchingSupportFragmentInjector.supportFragmentInjector();
        Preconditions.checkNotNull(dispatchingAndroidInjector, (String)"%s.supportFragmentInjector() returned null", (Object)hasDispatchingSupportFragmentInjector.getClass().getCanonicalName());
        dispatchingAndroidInjector.inject((Object)fragment);
    }

    private static HasDispatchingSupportFragmentInjector findHasFragmentInjector(Fragment fragment) {
        Fragment fragment2 = fragment;
        while ((fragment2 = fragment2.getParentFragment()) != null) {
            if (!(fragment2 instanceof HasDispatchingSupportFragmentInjector)) continue;
            return (HasDispatchingSupportFragmentInjector)fragment2;
        }
        FragmentActivity fragmentActivity = fragment.getActivity();
        if (fragmentActivity instanceof HasDispatchingSupportFragmentInjector) {
            return (HasDispatchingSupportFragmentInjector)fragmentActivity;
        }
        if (fragmentActivity.getApplication() instanceof HasDispatchingSupportFragmentInjector) {
            return (HasDispatchingSupportFragmentInjector)fragmentActivity.getApplication();
        }
        throw new IllegalArgumentException(String.format("No injector was found for %s", fragment.getClass().getCanonicalName()));
    }

    private AndroidSupportInjection() {
    }
}

