/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.internal.MonitoringUtil;
import com.google.crypto.tink.internal.MutableMonitoringRegistry;
import com.google.crypto.tink.monitoring.MonitoringClient;
import com.google.crypto.tink.monitoring.MonitoringKeysetInfo;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

class PublicKeyVerifyWrapper
implements PrimitiveWrapper<PublicKeyVerify, PublicKeyVerify> {
    private static final Logger logger = Logger.getLogger(PublicKeyVerifyWrapper.class.getName());
    private static final byte[] FORMAT_VERSION = new byte[]{0};

    PublicKeyVerifyWrapper() {
    }

    @Override
    public PublicKeyVerify wrap(PrimitiveSet<PublicKeyVerify> primitives) {
        return new WrappedPublicKeyVerify(primitives);
    }

    @Override
    public Class<PublicKeyVerify> getPrimitiveClass() {
        return PublicKeyVerify.class;
    }

    @Override
    public Class<PublicKeyVerify> getInputPrimitiveClass() {
        return PublicKeyVerify.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(new PublicKeyVerifyWrapper());
    }

    private static class WrappedPublicKeyVerify
    implements PublicKeyVerify {
        private final PrimitiveSet<PublicKeyVerify> primitives;
        private final MonitoringClient.Logger monitoringLogger;

        public WrappedPublicKeyVerify(PrimitiveSet<PublicKeyVerify> primitives) {
            this.primitives = primitives;
            if (primitives.hasAnnotations()) {
                MonitoringClient client = MutableMonitoringRegistry.globalInstance().getMonitoringClient();
                MonitoringKeysetInfo keysetInfo = MonitoringUtil.getMonitoringKeysetInfo(primitives);
                this.monitoringLogger = client.createLogger(keysetInfo, "public_key_verify", "verify");
            } else {
                this.monitoringLogger = MonitoringUtil.DO_NOTHING_LOGGER;
            }
        }

        @Override
        public void verify(byte[] signature, byte[] data) throws GeneralSecurityException {
            if (signature.length <= 5) {
                this.monitoringLogger.logFailure();
                throw new GeneralSecurityException("signature too short");
            }
            byte[] prefix = Arrays.copyOf(signature, 5);
            byte[] sigNoPrefix = Arrays.copyOfRange(signature, 5, signature.length);
            List<PrimitiveSet.Entry<PublicKeyVerify>> entries = this.primitives.getPrimitive(prefix);
            for (PrimitiveSet.Entry<PublicKeyVerify> entry : entries) {
                byte[] data2 = data;
                if (entry.getOutputPrefixType().equals(OutputPrefixType.LEGACY)) {
                    data2 = Bytes.concat(data2, FORMAT_VERSION);
                }
                try {
                    entry.getPrimitive().verify(sigNoPrefix, data2);
                    this.monitoringLogger.log(entry.getKeyId(), data2.length);
                    return;
                }
                catch (GeneralSecurityException e) {
                    logger.info("signature prefix matches a key, but cannot verify: " + e);
                }
            }
            entries = this.primitives.getRawPrimitives();
            for (PrimitiveSet.Entry<PublicKeyVerify> entry : entries) {
                try {
                    entry.getPrimitive().verify(signature, data);
                    this.monitoringLogger.log(entry.getKeyId(), data.length);
                    return;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
            this.monitoringLogger.logFailure();
            throw new GeneralSecurityException("invalid signature");
        }
    }
}

