/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.KmsClients;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KmsAeadKey;
import com.google.crypto.tink.proto.KmsAeadKeyFormat;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;

public class KmsAeadKeyManager
extends KeyTypeManager<KmsAeadKey> {
    KmsAeadKeyManager() {
        super(KmsAeadKey.class, new PrimitiveFactory<Aead, KmsAeadKey>(Aead.class){

            @Override
            public Aead getPrimitive(KmsAeadKey keyProto) throws GeneralSecurityException {
                String keyUri = keyProto.getParams().getKeyUri();
                KmsClient kmsClient = KmsClients.get(keyUri);
                return kmsClient.getAead(keyUri);
            }
        });
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.KmsAeadKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.REMOTE;
    }

    @Override
    public void validateKey(KmsAeadKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), this.getVersion());
    }

    @Override
    public KmsAeadKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return KmsAeadKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public KeyTypeManager.KeyFactory<KmsAeadKeyFormat, KmsAeadKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<KmsAeadKeyFormat, KmsAeadKey>(KmsAeadKeyFormat.class){

            @Override
            public void validateKeyFormat(KmsAeadKeyFormat format) throws GeneralSecurityException {
            }

            @Override
            public KmsAeadKeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return KmsAeadKeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public KmsAeadKey createKey(KmsAeadKeyFormat format) throws GeneralSecurityException {
                return (KmsAeadKey)KmsAeadKey.newBuilder().setParams(format).setVersion(KmsAeadKeyManager.this.getVersion()).build();
            }
        };
    }

    public static void register(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerKeyManager(new KmsAeadKeyManager(), newKeyAllowed);
    }

    public static KeyTemplate createKeyTemplate(String kekUri) {
        KmsAeadKeyFormat format = KmsAeadKeyManager.createKeyFormat(kekUri);
        return KeyTemplate.create(new KmsAeadKeyManager().getKeyType(), format.toByteArray(), KeyTemplate.OutputPrefixType.RAW);
    }

    static KmsAeadKeyFormat createKeyFormat(String keyUri) {
        return (KmsAeadKeyFormat)KmsAeadKeyFormat.newBuilder().setKeyUri(keyUri).build();
    }
}

