/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.prf.Prf;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;

@Immutable
public final class PrfHmacJce
implements Prf {
    static final int MIN_KEY_SIZE_IN_BYTES = 16;
    private final ThreadLocal<Mac> localMac = new ThreadLocal<Mac>(){

        @Override
        protected Mac initialValue() {
            try {
                Mac mac = EngineFactory.MAC.getInstance(PrfHmacJce.this.algorithm);
                mac.init(PrfHmacJce.this.key);
                return mac;
            }
            catch (GeneralSecurityException ex) {
                throw new IllegalStateException(ex);
            }
        }
    };
    private final String algorithm;
    private final Key key;
    private final int maxOutputLength;

    public PrfHmacJce(String algorithm, Key key) throws GeneralSecurityException {
        this.algorithm = algorithm;
        this.key = key;
        if (key.getEncoded().length < 16) {
            throw new InvalidAlgorithmParameterException("key size too small, need at least 16 bytes");
        }
        switch (algorithm) {
            case "HMACSHA1": {
                this.maxOutputLength = 20;
                break;
            }
            case "HMACSHA256": {
                this.maxOutputLength = 32;
                break;
            }
            case "HMACSHA384": {
                this.maxOutputLength = 48;
                break;
            }
            case "HMACSHA512": {
                this.maxOutputLength = 64;
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("unknown Hmac algorithm: " + algorithm);
            }
        }
        this.localMac.get();
    }

    @Override
    public byte[] compute(byte[] data, int outputLength) throws GeneralSecurityException {
        if (outputLength > this.maxOutputLength) {
            throw new InvalidAlgorithmParameterException("tag size too big");
        }
        this.localMac.get().update(data);
        return Arrays.copyOf(this.localMac.get().doFinal(), outputLength);
    }

    public int getMaxOutputLength() {
        return this.maxOutputLength;
    }
}

