/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.Util;
import com.google.crypto.tink.proto.EncryptedKeyset;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.KeysetInfo;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.subtle.Base64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonKeysetReader
implements KeysetReader {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final InputStream inputStream;
    private final JSONObject json;
    private final boolean closeStreamAfterReading;
    private boolean urlSafeBase64 = false;

    private JsonKeysetReader(InputStream inputStream, boolean closeStreamAfterReading) {
        this.inputStream = inputStream;
        this.closeStreamAfterReading = closeStreamAfterReading;
        this.json = null;
    }

    private JsonKeysetReader(JSONObject json) {
        this.json = json;
        this.inputStream = null;
        this.closeStreamAfterReading = false;
    }

    public static KeysetReader withInputStream(InputStream input) throws IOException {
        return new JsonKeysetReader(input, false);
    }

    public static JsonKeysetReader withJsonObject(JSONObject input) {
        return new JsonKeysetReader(input);
    }

    public static JsonKeysetReader withString(String input) {
        return new JsonKeysetReader(new ByteArrayInputStream(input.getBytes(UTF_8)), true);
    }

    public static JsonKeysetReader withBytes(byte[] bytes) {
        return new JsonKeysetReader(new ByteArrayInputStream(bytes), true);
    }

    public static JsonKeysetReader withFile(File file) throws IOException {
        return new JsonKeysetReader(new FileInputStream(file), true);
    }

    public static JsonKeysetReader withPath(String path) throws IOException {
        return JsonKeysetReader.withFile(new File(path));
    }

    public static JsonKeysetReader withPath(Path path) throws IOException {
        return JsonKeysetReader.withFile(path.toFile());
    }

    public JsonKeysetReader withUrlSafeBase64() {
        this.urlSafeBase64 = true;
        return this;
    }

    @Override
    public Keyset read() throws IOException {
        try {
            if (this.json != null) {
                Keyset keyset = this.keysetFromJson(this.json);
                return keyset;
            }
            Keyset keyset = this.keysetFromJson(new JSONObject(new String(Util.readAll(this.inputStream), UTF_8)));
            return keyset;
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        finally {
            if (this.inputStream != null && this.closeStreamAfterReading) {
                this.inputStream.close();
            }
        }
    }

    @Override
    public EncryptedKeyset readEncrypted() throws IOException {
        try {
            if (this.json != null) {
                EncryptedKeyset encryptedKeyset = this.encryptedKeysetFromJson(this.json);
                return encryptedKeyset;
            }
            EncryptedKeyset encryptedKeyset = this.encryptedKeysetFromJson(new JSONObject(new String(Util.readAll(this.inputStream), UTF_8)));
            return encryptedKeyset;
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        finally {
            if (this.inputStream != null && this.closeStreamAfterReading) {
                this.inputStream.close();
            }
        }
    }

    private Keyset keysetFromJson(JSONObject json) throws JSONException {
        JsonKeysetReader.validateKeyset(json);
        Keyset.Builder builder = Keyset.newBuilder();
        if (json.has("primaryKeyId")) {
            builder.setPrimaryKeyId(json.getInt("primaryKeyId"));
        }
        JSONArray keys = json.getJSONArray("key");
        for (int i = 0; i < keys.length(); ++i) {
            builder.addKey(this.keyFromJson(keys.getJSONObject(i)));
        }
        return (Keyset)builder.build();
    }

    private EncryptedKeyset encryptedKeysetFromJson(JSONObject json) throws JSONException {
        JsonKeysetReader.validateEncryptedKeyset(json);
        byte[] encryptedKeyset = this.urlSafeBase64 ? Base64.urlSafeDecode(json.getString("encryptedKeyset")) : Base64.decode(json.getString("encryptedKeyset"));
        return (EncryptedKeyset)EncryptedKeyset.newBuilder().setEncryptedKeyset(ByteString.copyFrom(encryptedKeyset)).setKeysetInfo(JsonKeysetReader.keysetInfoFromJson(json.getJSONObject("keysetInfo"))).build();
    }

    private Keyset.Key keyFromJson(JSONObject json) throws JSONException {
        JsonKeysetReader.validateKey(json);
        return (Keyset.Key)Keyset.Key.newBuilder().setStatus(JsonKeysetReader.getStatus(json.getString("status"))).setKeyId(json.getInt("keyId")).setOutputPrefixType(JsonKeysetReader.getOutputPrefixType(json.getString("outputPrefixType"))).setKeyData(this.keyDataFromJson(json.getJSONObject("keyData"))).build();
    }

    private static KeysetInfo keysetInfoFromJson(JSONObject json) throws JSONException {
        KeysetInfo.Builder builder = KeysetInfo.newBuilder();
        if (json.has("primaryKeyId")) {
            builder.setPrimaryKeyId(json.getInt("primaryKeyId"));
        }
        if (json.has("keyInfo")) {
            JSONArray keyInfos = json.getJSONArray("keyInfo");
            for (int i = 0; i < keyInfos.length(); ++i) {
                builder.addKeyInfo(JsonKeysetReader.keyInfoFromJson(keyInfos.getJSONObject(i)));
            }
        }
        return (KeysetInfo)builder.build();
    }

    private static KeysetInfo.KeyInfo keyInfoFromJson(JSONObject json) throws JSONException {
        return (KeysetInfo.KeyInfo)KeysetInfo.KeyInfo.newBuilder().setStatus(JsonKeysetReader.getStatus(json.getString("status"))).setKeyId(json.getInt("keyId")).setOutputPrefixType(JsonKeysetReader.getOutputPrefixType(json.getString("outputPrefixType"))).setTypeUrl(json.getString("typeUrl")).build();
    }

    private KeyData keyDataFromJson(JSONObject json) throws JSONException {
        JsonKeysetReader.validateKeyData(json);
        byte[] value = this.urlSafeBase64 ? Base64.urlSafeDecode(json.getString("value")) : Base64.decode(json.getString("value"));
        return (KeyData)KeyData.newBuilder().setTypeUrl(json.getString("typeUrl")).setValue(ByteString.copyFrom(value)).setKeyMaterialType(JsonKeysetReader.getKeyMaterialType(json.getString("keyMaterialType"))).build();
    }

    private static KeyStatusType getStatus(String status) throws JSONException {
        if (status.equals("ENABLED")) {
            return KeyStatusType.ENABLED;
        }
        if (status.equals("DISABLED")) {
            return KeyStatusType.DISABLED;
        }
        throw new JSONException("unknown status: " + status);
    }

    private static OutputPrefixType getOutputPrefixType(String type) throws JSONException {
        if (type.equals("TINK")) {
            return OutputPrefixType.TINK;
        }
        if (type.equals("RAW")) {
            return OutputPrefixType.RAW;
        }
        if (type.equals("LEGACY")) {
            return OutputPrefixType.LEGACY;
        }
        if (type.equals("CRUNCHY")) {
            return OutputPrefixType.CRUNCHY;
        }
        throw new JSONException("unknown output prefix type: " + type);
    }

    private static KeyData.KeyMaterialType getKeyMaterialType(String type) throws JSONException {
        if (type.equals("SYMMETRIC")) {
            return KeyData.KeyMaterialType.SYMMETRIC;
        }
        if (type.equals("ASYMMETRIC_PRIVATE")) {
            return KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE;
        }
        if (type.equals("ASYMMETRIC_PUBLIC")) {
            return KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC;
        }
        if (type.equals("REMOTE")) {
            return KeyData.KeyMaterialType.REMOTE;
        }
        throw new JSONException("unknown key material type: " + type);
    }

    private static void validateKeyset(JSONObject json) throws JSONException {
        if (!json.has("key") || json.getJSONArray("key").length() == 0) {
            throw new JSONException("invalid keyset");
        }
    }

    private static void validateEncryptedKeyset(JSONObject json) throws JSONException {
        if (!json.has("encryptedKeyset")) {
            throw new JSONException("invalid encrypted keyset");
        }
    }

    private static void validateKey(JSONObject json) throws JSONException {
        if (!(json.has("keyData") && json.has("status") && json.has("keyId") && json.has("outputPrefixType"))) {
            throw new JSONException("invalid key");
        }
    }

    private static void validateKeyData(JSONObject json) throws JSONException {
        if (!(json.has("typeUrl") && json.has("value") && json.has("keyMaterialType"))) {
            throw new JSONException("invalid keyData");
        }
    }
}

