/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.android;

import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Log;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.integration.android.AndroidKeystoreAesGcm;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.KeyGenerator;

public final class AndroidKeystoreKmsClient
implements KmsClient {
    private static final String TAG = AndroidKeystoreKmsClient.class.getSimpleName();
    public static final String PREFIX = "android-keystore://";
    private final String keyUri;
    private final KeyStore keyStore;

    public AndroidKeystoreKmsClient() throws GeneralSecurityException {
        this(new Builder());
    }

    @Deprecated
    public AndroidKeystoreKmsClient(String uri) {
        this(new Builder().setKeyUri(uri));
    }

    private AndroidKeystoreKmsClient(Builder builder) {
        this.keyUri = builder.keyUri;
        this.keyStore = builder.keyStore;
    }

    @Override
    public boolean doesSupport(String uri) {
        if (this.keyUri != null && this.keyUri.equals(uri)) {
            return true;
        }
        return this.keyUri == null && uri.toLowerCase(Locale.US).startsWith(PREFIX);
    }

    @Override
    public KmsClient withCredentials(String unused) throws GeneralSecurityException {
        return new AndroidKeystoreKmsClient();
    }

    @Override
    public KmsClient withDefaultCredentials() throws GeneralSecurityException {
        return new AndroidKeystoreKmsClient();
    }

    @Override
    public Aead getAead(String uri) throws GeneralSecurityException {
        if (this.keyUri != null && !this.keyUri.equals(uri)) {
            throw new GeneralSecurityException(String.format("this client is bound to %s, cannot load keys bound to %s", this.keyUri, uri));
        }
        AndroidKeystoreAesGcm aead = new AndroidKeystoreAesGcm(Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, uri), this.keyStore);
        return AndroidKeystoreKmsClient.validateAead(aead);
    }

    public void deleteKey(String keyUri) throws GeneralSecurityException {
        String keyId = Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, keyUri);
        this.keyStore.deleteEntry(keyId);
    }

    boolean hasKey(String keyUri) throws GeneralSecurityException {
        String keyId = Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, keyUri);
        return this.keyStore.containsAlias(keyId);
    }

    public static Aead getOrGenerateNewAeadKey(String keyUri) throws GeneralSecurityException, IOException {
        AndroidKeystoreKmsClient client = new AndroidKeystoreKmsClient();
        if (!client.hasKey(keyUri)) {
            Log.w((String)TAG, (String)String.format("key URI %s doesn't exist, generating a new one", keyUri));
            AndroidKeystoreKmsClient.generateNewAeadKey(keyUri);
        }
        return client.getAead(keyUri);
    }

    public static void generateNewAeadKey(String keyUri) throws GeneralSecurityException {
        AndroidKeystoreKmsClient client = new AndroidKeystoreKmsClient();
        if (client.hasKey(keyUri)) {
            throw new IllegalArgumentException(String.format("cannot generate a new key %s because it already exists; please delete it with deleteKey() and try again", keyUri));
        }
        String keyId = Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, keyUri);
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
        KeyGenParameterSpec spec = new KeyGenParameterSpec.Builder(keyId, 3).setKeySize(256).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).build();
        keyGenerator.init((AlgorithmParameterSpec)spec);
        keyGenerator.generateKey();
    }

    private static Aead validateAead(Aead aead) throws GeneralSecurityException {
        byte[] aad;
        byte[] ciphertext;
        byte[] decrypted;
        byte[] message = Random.randBytes(10);
        if (!Arrays.equals(message, decrypted = aead.decrypt(ciphertext = aead.encrypt(message, aad = new byte[0]), aad))) {
            throw new KeyStoreException("cannot use Android Keystore: encryption/decryption of non-empty message and empty aad returns an incorrect result");
        }
        return aead;
    }

    private static boolean isAtLeastM() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static final class Builder {
        String keyUri = null;
        KeyStore keyStore = null;

        public Builder() {
            if (!AndroidKeystoreKmsClient.isAtLeastM()) {
                throw new IllegalStateException("need Android Keystore on Android M or newer");
            }
            try {
                this.keyStore = KeyStore.getInstance("AndroidKeyStore");
                this.keyStore.load(null);
            }
            catch (IOException | GeneralSecurityException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public Builder setKeyUri(String val) {
            if (val == null || !val.toLowerCase(Locale.US).startsWith(AndroidKeystoreKmsClient.PREFIX)) {
                throw new IllegalArgumentException("val must start with android-keystore://");
            }
            this.keyUri = val;
            return this;
        }

        public Builder setKeyStore(KeyStore val) {
            if (val == null) {
                throw new IllegalArgumentException("val cannot be null");
            }
            this.keyStore = val;
            return this;
        }

        public AndroidKeystoreKmsClient build() {
            return new AndroidKeystoreKmsClient(this);
        }
    }
}

