/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.proto.EncryptedKeyset;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BinaryKeysetReader
implements KeysetReader {
    private final InputStream inputStream;
    private final boolean closeStreamAfterReading;

    public static KeysetReader withInputStream(InputStream stream) {
        return new BinaryKeysetReader(stream, false);
    }

    public static KeysetReader withBytes(byte[] bytes) {
        return new BinaryKeysetReader(new ByteArrayInputStream(bytes), true);
    }

    public static KeysetReader withFile(File file) throws IOException {
        return new BinaryKeysetReader(new FileInputStream(file), true);
    }

    private BinaryKeysetReader(InputStream stream, boolean closeStreamAfterReading) {
        this.inputStream = stream;
        this.closeStreamAfterReading = closeStreamAfterReading;
    }

    @Override
    public Keyset read() throws IOException {
        try {
            Keyset keyset;
            Keyset keyset2 = keyset = Keyset.parseFrom(this.inputStream, ExtensionRegistryLite.getEmptyRegistry());
            return keyset2;
        }
        finally {
            if (this.closeStreamAfterReading) {
                this.inputStream.close();
            }
        }
    }

    @Override
    public EncryptedKeyset readEncrypted() throws IOException {
        try {
            EncryptedKeyset keyset;
            EncryptedKeyset encryptedKeyset = keyset = EncryptedKeyset.parseFrom(this.inputStream, ExtensionRegistryLite.getEmptyRegistry());
            return encryptedKeyset;
        }
        finally {
            if (this.closeStreamAfterReading) {
                this.inputStream.close();
            }
        }
    }
}

