/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.android;

import android.annotation.TargetApi;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.integration.android.AndroidKeystoreAesGcm;
import com.google.crypto.tink.subtle.Validators;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;

@TargetApi(value=23)
public final class AndroidKeystoreKmsClient
implements KmsClient {
    public static final String PREFIX = "android-keystore://";
    private String keyUri;

    public AndroidKeystoreKmsClient() throws GeneralSecurityException {
        if (!this.isAtLeastM()) {
            throw new GeneralSecurityException("needs Android Keystore on Android M or newer");
        }
    }

    public AndroidKeystoreKmsClient(String uri) {
        if (!uri.toLowerCase().startsWith(PREFIX)) {
            throw new IllegalArgumentException("key URI must starts with android-keystore://");
        }
        this.keyUri = uri;
    }

    @Override
    public boolean doesSupport(String uri) {
        if (this.keyUri != null && this.keyUri.equals(uri)) {
            return true;
        }
        return this.keyUri == null && uri.toLowerCase().startsWith(PREFIX);
    }

    @Override
    public KmsClient withCredentials(String unused) throws GeneralSecurityException {
        return new AndroidKeystoreKmsClient();
    }

    @Override
    public KmsClient withDefaultCredentials() throws GeneralSecurityException {
        return new AndroidKeystoreKmsClient();
    }

    private boolean isAtLeastM() {
        return Build.VERSION.SDK_INT >= 23;
    }

    @Override
    public Aead getAead(String uri) throws GeneralSecurityException {
        if (this.keyUri != null && !this.keyUri.equals(uri)) {
            throw new GeneralSecurityException(String.format("this client is bound to %s, cannot load keys bound to %s", this.keyUri, uri));
        }
        try {
            return new AndroidKeystoreAesGcm(Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, uri));
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public static Aead getOrGenerateNewAeadKey(String keyUri) throws GeneralSecurityException, IOException {
        String keyId = Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, keyUri);
        KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
        keyStore.load(null);
        if (!keyStore.containsAlias(keyId)) {
            AndroidKeystoreKmsClient.generateNewAeadKey(keyUri);
        }
        return new AndroidKeystoreKmsClient().getAead(keyUri);
    }

    public static void generateNewAeadKey(String keyUri) throws GeneralSecurityException {
        String keyId = Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, keyUri);
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
        KeyGenParameterSpec spec = new KeyGenParameterSpec.Builder(keyId, 3).setKeySize(256).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).build();
        keyGenerator.init((AlgorithmParameterSpec)spec);
        keyGenerator.generateKey();
    }

    static void delete(String keyUri) throws GeneralSecurityException, IOException {
        String keyId = Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, keyUri);
        KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
        keyStore.load(null);
        keyStore.deleteEntry(keyId);
    }
}

