/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.Validators;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;

public class SubtleUtil {
    public static String toEcdsaAlgo(Enums.HashType hash) throws GeneralSecurityException {
        Validators.validateSignatureHash(hash);
        return (Object)((Object)hash) + "withECDSA";
    }

    public static String toRsaSsaPkcs1Algo(Enums.HashType hash) throws GeneralSecurityException {
        Validators.validateSignatureHash(hash);
        return (Object)((Object)hash) + "withRSA";
    }

    public static String toDigestAlgo(Enums.HashType hash) throws GeneralSecurityException {
        switch (hash) {
            case SHA1: {
                return "SHA-1";
            }
            case SHA256: {
                return "SHA-256";
            }
            case SHA384: {
                return "SHA-384";
            }
            case SHA512: {
                return "SHA-512";
            }
        }
        throw new GeneralSecurityException("Unsupported hash " + (Object)((Object)hash));
    }

    public static boolean isAndroid() {
        try {
            Class.forName("android.app.Application", false, null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static BigInteger bytes2Integer(byte[] bs) {
        return new BigInteger(1, bs);
    }

    public static byte[] integer2Bytes(BigInteger num, int intendedLength) throws GeneralSecurityException {
        byte[] b = num.toByteArray();
        if (b.length == intendedLength) {
            return b;
        }
        if (b.length > intendedLength + 1) {
            throw new GeneralSecurityException("integer too large");
        }
        if (b.length == intendedLength + 1) {
            if (b[0] == 0) {
                return Arrays.copyOfRange(b, 1, b.length);
            }
            throw new GeneralSecurityException("integer too large");
        }
        byte[] res = new byte[intendedLength];
        System.arraycopy(b, 0, res, intendedLength - b.length, b.length);
        return res;
    }

    public static byte[] mgf1(byte[] mgfSeed, int maskLen, Enums.HashType mgfHash) throws GeneralSecurityException {
        MessageDigest digest = EngineFactory.MESSAGE_DIGEST.getInstance(SubtleUtil.toDigestAlgo(mgfHash));
        int hLen = digest.getDigestLength();
        byte[] t = new byte[maskLen];
        int tPos = 0;
        for (int counter = 0; counter <= (maskLen - 1) / hLen; ++counter) {
            digest.reset();
            digest.update(mgfSeed);
            digest.update(SubtleUtil.integer2Bytes(BigInteger.valueOf(counter), 4));
            byte[] c = digest.digest();
            System.arraycopy(c, 0, t, tPos, Math.min(c.length, t.length - tPos));
            tPos += c.length;
        }
        return t;
    }

    public static void putAsUnsigedInt(ByteBuffer buffer, long value) throws GeneralSecurityException {
        if (0L > value || value >= 0x100000000L) {
            throw new GeneralSecurityException("Index out of range");
        }
        buffer.putInt((int)value);
    }
}

