/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.subtle.AesCmac;
import com.google.crypto.tink.subtle.AesUtil;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.SubtleUtil;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import java.util.Collection;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AesSiv
implements DeterministicAead {
    private static final Collection<Integer> KEY_SIZES = Arrays.asList(64);
    private static final byte[] BLOCK_ZERO = new byte[16];
    private static final byte[] BLOCK_ONE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private final AesCmac cmacForS2V;
    private final byte[] aesCtrKey;

    public AesSiv(byte[] key) throws GeneralSecurityException {
        if (!KEY_SIZES.contains(key.length)) {
            throw new InvalidKeyException("invalid key size: " + key.length + " bytes; key must have 64 bytes");
        }
        byte[] k1 = Arrays.copyOfRange(key, 0, key.length / 2);
        this.aesCtrKey = Arrays.copyOfRange(key, key.length / 2, key.length);
        this.cmacForS2V = new AesCmac(k1, 16);
    }

    private byte[] s2v(byte[] ... s) throws GeneralSecurityException {
        if (s.length == 0) {
            return this.cmacForS2V.computeMac(BLOCK_ONE);
        }
        byte[] result = this.cmacForS2V.computeMac(BLOCK_ZERO);
        for (int i = 0; i < s.length - 1; ++i) {
            byte[] currBlock = s[i] == null ? new byte[]{} : s[i];
            result = Bytes.xor(AesUtil.dbl(result), this.cmacForS2V.computeMac(currBlock));
        }
        byte[] lastBlock = s[s.length - 1];
        result = lastBlock.length >= 16 ? Bytes.xorEnd(lastBlock, result) : Bytes.xor(AesUtil.cmacPad(lastBlock), AesUtil.dbl(result));
        return this.cmacForS2V.computeMac(result);
    }

    @Override
    public byte[] encryptDeterministically(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        if (plaintext.length > 0x7FFFFFEF) {
            throw new GeneralSecurityException("plaintext too long");
        }
        Cipher aesCtr = EngineFactory.CIPHER.getInstance("AES/CTR/NoPadding");
        byte[] computedIv = this.s2v(associatedData, plaintext);
        byte[] ivForJavaCrypto = (byte[])computedIv.clone();
        ivForJavaCrypto[8] = (byte)(ivForJavaCrypto[8] & 0x7F);
        ivForJavaCrypto[12] = (byte)(ivForJavaCrypto[12] & 0x7F);
        aesCtr.init(1, (Key)new SecretKeySpec(this.aesCtrKey, "AES"), new IvParameterSpec(ivForJavaCrypto));
        byte[] ctrCiphertext = aesCtr.doFinal(plaintext);
        return Bytes.concat(computedIv, ctrCiphertext);
    }

    @Override
    public byte[] decryptDeterministically(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        byte[] computedIv;
        if (ciphertext.length < 16) {
            throw new GeneralSecurityException("Ciphertext too short.");
        }
        Cipher aesCtr = EngineFactory.CIPHER.getInstance("AES/CTR/NoPadding");
        byte[] expectedIv = Arrays.copyOfRange(ciphertext, 0, 16);
        byte[] ivForJavaCrypto = (byte[])expectedIv.clone();
        ivForJavaCrypto[8] = (byte)(ivForJavaCrypto[8] & 0x7F);
        ivForJavaCrypto[12] = (byte)(ivForJavaCrypto[12] & 0x7F);
        aesCtr.init(2, (Key)new SecretKeySpec(this.aesCtrKey, "AES"), new IvParameterSpec(ivForJavaCrypto));
        byte[] ctrCiphertext = Arrays.copyOfRange(ciphertext, 16, ciphertext.length);
        byte[] decryptedPt = aesCtr.doFinal(ctrCiphertext);
        if (ctrCiphertext.length == 0 && decryptedPt == null && SubtleUtil.isAndroid()) {
            decryptedPt = new byte[]{};
        }
        if (Bytes.equal(expectedIv, computedIv = this.s2v(associatedData, decryptedPt))) {
            return decryptedPt;
        }
        throw new AEADBadTagException("Integrity check failed.");
    }
}

