/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class HybridDecryptWrapper
implements PrimitiveWrapper<HybridDecrypt> {
    private static final Logger logger = Logger.getLogger(HybridDecryptWrapper.class.getName());

    HybridDecryptWrapper() {
    }

    @Override
    public HybridDecrypt wrap(PrimitiveSet<HybridDecrypt> primitives) {
        return new WrappedHybridDecrypt(primitives);
    }

    @Override
    public Class<HybridDecrypt> getPrimitiveClass() {
        return HybridDecrypt.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(new HybridDecryptWrapper());
    }

    private static class WrappedHybridDecrypt
    implements HybridDecrypt {
        private final PrimitiveSet<HybridDecrypt> primitives;

        public WrappedHybridDecrypt(PrimitiveSet<HybridDecrypt> primitives) {
            this.primitives = primitives;
        }

        @Override
        public byte[] decrypt(byte[] ciphertext, byte[] contextInfo) throws GeneralSecurityException {
            if (ciphertext.length > 5) {
                byte[] prefix = Arrays.copyOfRange(ciphertext, 0, 5);
                byte[] ciphertextNoPrefix = Arrays.copyOfRange(ciphertext, 5, ciphertext.length);
                List<PrimitiveSet.Entry<HybridDecrypt>> entries = this.primitives.getPrimitive(prefix);
                for (PrimitiveSet.Entry<HybridDecrypt> entry : entries) {
                    try {
                        return entry.getPrimitive().decrypt(ciphertextNoPrefix, contextInfo);
                    }
                    catch (GeneralSecurityException e) {
                        logger.info("ciphertext prefix matches a key, but cannot decrypt: " + e.toString());
                    }
                }
            }
            List<PrimitiveSet.Entry<HybridDecrypt>> entries = this.primitives.getRawPrimitives();
            for (PrimitiveSet.Entry<HybridDecrypt> entry : entries) {
                try {
                    return entry.getPrimitive().decrypt(ciphertext, contextInfo);
                }
                catch (GeneralSecurityException e) {
                }
            }
            throw new GeneralSecurityException("decryption failed");
        }
    }
}

