/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.streamingaead;

import com.google.crypto.tink.KeyTypeManager;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.proto.AesCtrHmacStreamingKey;
import com.google.crypto.tink.proto.AesCtrHmacStreamingKeyFormat;
import com.google.crypto.tink.proto.AesCtrHmacStreamingParams;
import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.proto.HmacParams;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.streamingaead.StreamingAeadUtil;
import com.google.crypto.tink.subtle.AesCtrHmacStreaming;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

public class AesCtrHmacStreamingKeyManager
extends KeyTypeManager<AesCtrHmacStreamingKey> {
    private static final int MIN_TAG_SIZE_IN_BYTES = 10;
    private static final int NONCE_PREFIX_IN_BYTES = 7;

    AesCtrHmacStreamingKeyManager() {
        super(AesCtrHmacStreamingKey.class, new KeyTypeManager.PrimitiveFactory<StreamingAead, AesCtrHmacStreamingKey>(StreamingAead.class){

            @Override
            public StreamingAead getPrimitive(AesCtrHmacStreamingKey key) throws GeneralSecurityException {
                return new AesCtrHmacStreaming(key.getKeyValue().toByteArray(), StreamingAeadUtil.toHmacAlgo(key.getParams().getHkdfHashType()), key.getParams().getDerivedKeySize(), StreamingAeadUtil.toHmacAlgo(key.getParams().getHmacParams().getHash()), key.getParams().getHmacParams().getTagSize(), key.getParams().getCiphertextSegmentSize(), 0);
            }
        });
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.AesCtrHmacStreamingKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    public void validateKey(AesCtrHmacStreamingKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), this.getVersion());
        if (key.getKeyValue().size() < 16) {
            throw new GeneralSecurityException("key_value must have at least 16 bytes");
        }
        if (key.getKeyValue().size() < key.getParams().getDerivedKeySize()) {
            throw new GeneralSecurityException("key_value must have at least as many bits as derived keys");
        }
        AesCtrHmacStreamingKeyManager.validateParams(key.getParams());
    }

    @Override
    public AesCtrHmacStreamingKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return AesCtrHmacStreamingKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public KeyTypeManager.KeyFactory<AesCtrHmacStreamingKeyFormat, AesCtrHmacStreamingKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<AesCtrHmacStreamingKeyFormat, AesCtrHmacStreamingKey>(AesCtrHmacStreamingKeyFormat.class){

            @Override
            public void validateKeyFormat(AesCtrHmacStreamingKeyFormat format) throws GeneralSecurityException {
                if (format.getKeySize() < 16) {
                    throw new GeneralSecurityException("key_size must be at least 16 bytes");
                }
                AesCtrHmacStreamingKeyManager.validateParams(format.getParams());
            }

            @Override
            public AesCtrHmacStreamingKeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return AesCtrHmacStreamingKeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public AesCtrHmacStreamingKey createKey(AesCtrHmacStreamingKeyFormat format) throws GeneralSecurityException {
                return (AesCtrHmacStreamingKey)AesCtrHmacStreamingKey.newBuilder().setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).setParams(format.getParams()).setVersion(AesCtrHmacStreamingKeyManager.this.getVersion()).build();
            }
        };
    }

    private static void validateParams(AesCtrHmacStreamingParams params) throws GeneralSecurityException {
        Validators.validateAesKeySize(params.getDerivedKeySize());
        if (params.getHkdfHashType() == HashType.UNKNOWN_HASH) {
            throw new GeneralSecurityException("unknown HKDF hash type");
        }
        if (params.getHmacParams().getHash() == HashType.UNKNOWN_HASH) {
            throw new GeneralSecurityException("unknown HMAC hash type");
        }
        AesCtrHmacStreamingKeyManager.validateHmacParams(params.getHmacParams());
        if (params.getCiphertextSegmentSize() < params.getDerivedKeySize() + params.getHmacParams().getTagSize() + 2 + 7) {
            throw new GeneralSecurityException("ciphertext_segment_size must be at least (derived_key_size + tag_size + NONCE_PREFIX_IN_BYTES + 2)");
        }
    }

    private static void validateHmacParams(HmacParams params) throws GeneralSecurityException {
        if (params.getTagSize() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (params.getHash()) {
            case SHA1: {
                if (params.getTagSize() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case SHA256: {
                if (params.getTagSize() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case SHA512: {
                if (params.getTagSize() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }

    public static void register(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerKeyManager(new AesCtrHmacStreamingKeyManager(), newKeyAllowed);
    }
}

