/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.Registry;
import com.google.crypto.tink.proto.EcPointFormat;
import com.google.crypto.tink.proto.EciesAeadHkdfParams;
import com.google.crypto.tink.proto.EllipticCurveType;
import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.subtle.EllipticCurves;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;

class HybridUtil {
    HybridUtil() {
    }

    public static void validate(EciesAeadHkdfParams params) throws GeneralSecurityException {
        EllipticCurves.getCurveSpec(HybridUtil.toCurveType(params.getKemParams().getCurveType()));
        HybridUtil.toHmacAlgo(params.getKemParams().getHkdfHashType());
        if (params.getEcPointFormat() == EcPointFormat.UNKNOWN_FORMAT) {
            throw new GeneralSecurityException("unknown EC point format");
        }
        Registry.newKeyData(params.getDemParams().getAeadDem());
    }

    public static String toHmacAlgo(HashType hash) throws NoSuchAlgorithmException {
        switch (hash) {
            case SHA1: {
                return "HmacSha1";
            }
            case SHA256: {
                return "HmacSha256";
            }
            case SHA512: {
                return "HmacSha512";
            }
        }
        throw new NoSuchAlgorithmException("hash unsupported for HMAC: " + (Object)((Object)hash));
    }

    public static EllipticCurves.CurveType toCurveType(EllipticCurveType type) throws GeneralSecurityException {
        switch (type) {
            case NIST_P256: {
                return EllipticCurves.CurveType.NIST_P256;
            }
            case NIST_P384: {
                return EllipticCurves.CurveType.NIST_P384;
            }
            case NIST_P521: {
                return EllipticCurves.CurveType.NIST_P521;
            }
        }
        throw new GeneralSecurityException("unknown curve type: " + (Object)((Object)type));
    }

    public static EllipticCurves.PointFormatType toPointFormatType(EcPointFormat format) throws GeneralSecurityException {
        switch (format) {
            case UNCOMPRESSED: {
                return EllipticCurves.PointFormatType.UNCOMPRESSED;
            }
            case DO_NOT_USE_CRUNCHY_UNCOMPRESSED: {
                return EllipticCurves.PointFormatType.DO_NOT_USE_CRUNCHY_UNCOMPRESSED;
            }
            case COMPRESSED: {
                return EllipticCurves.PointFormatType.COMPRESSED;
            }
        }
        throw new GeneralSecurityException("unknown point format: " + (Object)((Object)format));
    }
}

