/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.daead;

import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class DeterministicAeadWrapper
implements PrimitiveWrapper<DeterministicAead> {
    private static final Logger logger = Logger.getLogger(DeterministicAeadWrapper.class.getName());

    DeterministicAeadWrapper() {
    }

    @Override
    public DeterministicAead wrap(PrimitiveSet<DeterministicAead> primitives) {
        return new WrappedDeterministicAead(primitives);
    }

    @Override
    public Class<DeterministicAead> getPrimitiveClass() {
        return DeterministicAead.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(new DeterministicAeadWrapper());
    }

    private static class WrappedDeterministicAead
    implements DeterministicAead {
        private PrimitiveSet<DeterministicAead> primitives;

        public WrappedDeterministicAead(PrimitiveSet<DeterministicAead> primitives) {
            this.primitives = primitives;
        }

        @Override
        public byte[] encryptDeterministically(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
            return Bytes.concat(this.primitives.getPrimary().getIdentifier(), this.primitives.getPrimary().getPrimitive().encryptDeterministically(plaintext, associatedData));
        }

        @Override
        public byte[] decryptDeterministically(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
            if (ciphertext.length > 5) {
                byte[] prefix = Arrays.copyOfRange(ciphertext, 0, 5);
                byte[] ciphertextNoPrefix = Arrays.copyOfRange(ciphertext, 5, ciphertext.length);
                List<PrimitiveSet.Entry<DeterministicAead>> entries = this.primitives.getPrimitive(prefix);
                for (PrimitiveSet.Entry<DeterministicAead> entry : entries) {
                    try {
                        return entry.getPrimitive().decryptDeterministically(ciphertextNoPrefix, associatedData);
                    }
                    catch (GeneralSecurityException e) {
                        logger.info("ciphertext prefix matches a key, but cannot decrypt: " + e.toString());
                    }
                }
            }
            List<PrimitiveSet.Entry<DeterministicAead>> entries = this.primitives.getRawPrimitives();
            for (PrimitiveSet.Entry<DeterministicAead> entry : entries) {
                try {
                    return entry.getPrimitive().decryptDeterministically(ciphertext, associatedData);
                }
                catch (GeneralSecurityException e) {
                }
            }
            throw new GeneralSecurityException("decryption failed");
        }
    }
}

