/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.Mac;
import com.google.crypto.tink.subtle.AesUtil;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class AesCmac
implements Mac {
    static final int MIN_TAG_SIZE_IN_BYTES = 10;
    private final SecretKey keySpec;
    private final int tagSizeInBytes;
    private byte[] subKey1;
    private byte[] subKey2;

    private static Cipher instance() throws GeneralSecurityException {
        return EngineFactory.CIPHER.getInstance("AES/ECB/NoPadding");
    }

    public AesCmac(byte[] key, int tagSizeInBytes) throws GeneralSecurityException {
        Validators.validateAesKeySize(key.length);
        if (tagSizeInBytes < 10) {
            throw new InvalidAlgorithmParameterException("tag size too small, min is 10 bytes");
        }
        if (tagSizeInBytes > 16) {
            throw new InvalidAlgorithmParameterException("tag size too large, max is 16 bytes");
        }
        this.keySpec = new SecretKeySpec(key, "AES");
        this.tagSizeInBytes = tagSizeInBytes;
        this.generateSubKeys();
    }

    @Override
    public byte[] computeMac(byte[] data) throws GeneralSecurityException {
        byte[] y;
        Cipher aes = AesCmac.instance();
        aes.init(1, this.keySpec);
        int n = Math.max(1, (int)Math.ceil((double)data.length / 16.0));
        boolean flag = n * 16 == data.length;
        byte[] mLast = flag ? Bytes.xor(data, (n - 1) * 16, this.subKey1, 0, 16) : Bytes.xor(AesUtil.cmacPad(Arrays.copyOfRange(data, (n - 1) * 16, data.length)), this.subKey2);
        byte[] x = new byte[16];
        for (int i = 0; i < n - 1; ++i) {
            y = Bytes.xor(x, 0, data, i * 16, 16);
            x = aes.doFinal(y);
        }
        y = Bytes.xor(mLast, x);
        byte[] tag = new byte[this.tagSizeInBytes];
        System.arraycopy(aes.doFinal(y), 0, tag, 0, this.tagSizeInBytes);
        return tag;
    }

    @Override
    public void verifyMac(byte[] mac, byte[] data) throws GeneralSecurityException {
        if (!Bytes.equal(mac, this.computeMac(data))) {
            throw new GeneralSecurityException("invalid MAC");
        }
    }

    private void generateSubKeys() throws GeneralSecurityException {
        Cipher aes = AesCmac.instance();
        aes.init(1, this.keySpec);
        byte[] zeroes = new byte[16];
        byte[] l = aes.doFinal(zeroes);
        this.subKey1 = AesUtil.dbl(l);
        this.subKey2 = AesUtil.dbl(this.subKey1);
    }
}

