/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.mac;

import com.google.crypto.tink.Mac;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

class MacWrapper
implements PrimitiveWrapper<Mac> {
    private static final Logger logger = Logger.getLogger(MacWrapper.class.getName());

    MacWrapper() {
    }

    @Override
    public Mac wrap(PrimitiveSet<Mac> primitives) throws GeneralSecurityException {
        return new WrappedMac(primitives);
    }

    @Override
    public Class<Mac> getPrimitiveClass() {
        return Mac.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(new MacWrapper());
    }

    private static class WrappedMac
    implements Mac {
        private final PrimitiveSet<Mac> primitives;
        private final byte[] formatVersion = new byte[]{0};

        private WrappedMac(PrimitiveSet<Mac> primitives) {
            this.primitives = primitives;
        }

        @Override
        public byte[] computeMac(byte[] data) throws GeneralSecurityException {
            if (this.primitives.getPrimary().getOutputPrefixType().equals((Object)OutputPrefixType.LEGACY)) {
                return Bytes.concat(this.primitives.getPrimary().getIdentifier(), this.primitives.getPrimary().getPrimitive().computeMac(Bytes.concat(data, this.formatVersion)));
            }
            return Bytes.concat(this.primitives.getPrimary().getIdentifier(), this.primitives.getPrimary().getPrimitive().computeMac(data));
        }

        @Override
        public void verifyMac(byte[] mac, byte[] data) throws GeneralSecurityException {
            if (mac.length <= 5) {
                throw new GeneralSecurityException("tag too short");
            }
            byte[] prefix = Arrays.copyOfRange(mac, 0, 5);
            byte[] macNoPrefix = Arrays.copyOfRange(mac, 5, mac.length);
            List<PrimitiveSet.Entry<Mac>> entries = this.primitives.getPrimitive(prefix);
            for (PrimitiveSet.Entry<Mac> entry : entries) {
                try {
                    if (entry.getOutputPrefixType().equals((Object)OutputPrefixType.LEGACY)) {
                        entry.getPrimitive().verifyMac(macNoPrefix, Bytes.concat(data, this.formatVersion));
                    } else {
                        entry.getPrimitive().verifyMac(macNoPrefix, data);
                    }
                    return;
                }
                catch (GeneralSecurityException e) {
                    logger.info("tag prefix matches a key, but cannot verify: " + e.toString());
                }
            }
            entries = this.primitives.getRawPrimitives();
            for (PrimitiveSet.Entry<Mac> entry : entries) {
                try {
                    entry.getPrimitive().verifyMac(mac, data);
                    return;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
            throw new GeneralSecurityException("invalid MAC");
        }
    }
}

