/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.proto.EncryptedKeyset;
import com.google.crypto.tink.proto.Keyset;
import com.google.protobuf.ExtensionRegistryLite;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BinaryKeysetReader
implements KeysetReader {
    private final InputStream inputStream;

    public static KeysetReader withInputStream(InputStream stream) {
        return new BinaryKeysetReader(stream);
    }

    public static KeysetReader withBytes(byte[] bytes) {
        return new BinaryKeysetReader(new ByteArrayInputStream(bytes));
    }

    public static KeysetReader withFile(File file) throws IOException {
        return new BinaryKeysetReader(new FileInputStream(file));
    }

    private BinaryKeysetReader(InputStream stream) {
        this.inputStream = stream;
    }

    @Override
    public Keyset read() throws IOException {
        return Keyset.parseFrom(this.inputStream, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public EncryptedKeyset readEncrypted() throws IOException {
        return EncryptedKeyset.parseFrom(this.inputStream, ExtensionRegistryLite.getEmptyRegistry());
    }
}

