/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.annotation.concurrent.GuardedBy;

public final class RewindableReadableByteChannel
implements ReadableByteChannel {
    @GuardedBy(value="this")
    final ReadableByteChannel baseChannel;
    @GuardedBy(value="this")
    ByteBuffer buffer;
    @GuardedBy(value="this")
    boolean canRewind;
    @GuardedBy(value="this")
    boolean directRead;

    public RewindableReadableByteChannel(ReadableByteChannel baseChannel) {
        this.baseChannel = baseChannel;
        this.buffer = null;
        this.canRewind = true;
        this.directRead = false;
    }

    @GuardedBy(value="this")
    public synchronized void disableRewinding() {
        this.canRewind = false;
    }

    @GuardedBy(value="this")
    public synchronized void rewind() throws IOException {
        if (!this.canRewind) {
            throw new IOException("Cannot rewind anymore.");
        }
        if (this.buffer != null) {
            this.buffer.position(0);
        }
    }

    @Override
    @GuardedBy(value="this")
    public synchronized int read(ByteBuffer dst) throws IOException {
        if (this.directRead) {
            return this.baseChannel.read(dst);
        }
        int bytesToReadCount = dst.remaining();
        if (bytesToReadCount == 0) {
            return 0;
        }
        if (this.buffer == null) {
            if (!this.canRewind) {
                this.directRead = true;
                return this.baseChannel.read(dst);
            }
            this.buffer = ByteBuffer.allocate(bytesToReadCount);
            int readBytesCount = this.baseChannel.read(this.buffer);
            if (readBytesCount > 0) {
                this.buffer.flip();
                dst.put(this.buffer);
            }
            return readBytesCount;
        }
        if (this.buffer.remaining() >= bytesToReadCount) {
            byte[] toDst = new byte[bytesToReadCount];
            this.buffer.get(toDst);
            dst.put(toDst);
            if (!this.canRewind && this.buffer.remaining() == 0) {
                this.directRead = true;
            }
            return bytesToReadCount;
        }
        int bytesFromBufferCount = this.buffer.remaining();
        int stillToReadCount = bytesToReadCount - bytesFromBufferCount;
        dst.put(this.buffer);
        ByteBuffer extraBuffer = ByteBuffer.allocate(stillToReadCount);
        int readBytesCount = this.baseChannel.read(extraBuffer);
        if (readBytesCount > 0) {
            extraBuffer.flip();
            dst.put(extraBuffer);
        }
        if (this.canRewind) {
            int newBufferSize = this.buffer.limit() + stillToReadCount;
            ByteBuffer newBuffer = ByteBuffer.allocate(newBufferSize);
            this.buffer.flip();
            newBuffer.put(this.buffer);
            if (readBytesCount > 0) {
                extraBuffer.flip();
                newBuffer.put(extraBuffer);
            }
            newBuffer.flip();
            newBuffer.position(newBuffer.limit());
            this.buffer = newBuffer;
        } else {
            this.buffer = null;
            this.directRead = true;
        }
        return bytesFromBufferCount + readBytesCount;
    }

    @Override
    @GuardedBy(value="this")
    public synchronized void close() throws IOException {
        this.canRewind = false;
        this.directRead = true;
        this.baseChannel.close();
    }

    @Override
    @GuardedBy(value="this")
    public synchronized boolean isOpen() {
        return this.baseChannel.isOpen();
    }
}

