/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.streamingaead;

import com.google.crypto.tink.Catalogue;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.streamingaead.AesCtrHmacStreamingKeyManager;
import com.google.crypto.tink.streamingaead.AesGcmHkdfStreamingKeyManager;
import com.google.crypto.tink.streamingaead.StreamingAeadWrapper;
import java.security.GeneralSecurityException;

class StreamingAeadCatalogue
implements Catalogue<StreamingAead> {
    @Override
    public KeyManager<StreamingAead> getKeyManager(String typeUrl, String primitiveName, int minVersion) throws GeneralSecurityException {
        KeyManager<StreamingAead> keyManager;
        switch (primitiveName.toLowerCase()) {
            case "streamingaead": {
                keyManager = this.streamingAeadKeyManager(typeUrl);
                break;
            }
            default: {
                throw new GeneralSecurityException(String.format("No support for primitive '%s'.", primitiveName));
            }
        }
        if (keyManager.getVersion() < minVersion) {
            throw new GeneralSecurityException(String.format("No key manager for key type '%s' with version at least %d.", typeUrl, minVersion));
        }
        return keyManager;
    }

    private KeyManager<StreamingAead> streamingAeadKeyManager(String typeUrl) throws GeneralSecurityException {
        switch (typeUrl) {
            case "type.googleapis.com/google.crypto.tink.AesCtrHmacStreamingKey": {
                return new AesCtrHmacStreamingKeyManager();
            }
            case "type.googleapis.com/google.crypto.tink.AesGcmHkdfStreamingKey": {
                return new AesGcmHkdfStreamingKeyManager();
            }
        }
        throw new GeneralSecurityException(String.format("No support for primitive 'StreamingAead' with key type '%s'.", typeUrl));
    }

    @Override
    public PrimitiveWrapper<StreamingAead> getPrimitiveWrapper() {
        return new StreamingAeadWrapper();
    }
}

