/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.streamingaead;

import com.google.crypto.tink.KeyManagerBase;
import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.proto.AesGcmHkdfStreamingKey;
import com.google.crypto.tink.proto.AesGcmHkdfStreamingKeyFormat;
import com.google.crypto.tink.proto.AesGcmHkdfStreamingParams;
import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.streamingaead.StreamingAeadUtil;
import com.google.crypto.tink.subtle.AesGcmHkdfStreaming;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

class AesGcmHkdfStreamingKeyManager
extends KeyManagerBase<StreamingAead, AesGcmHkdfStreamingKey, AesGcmHkdfStreamingKeyFormat> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.AesGcmHkdfStreamingKey";

    public AesGcmHkdfStreamingKeyManager() {
        super(StreamingAead.class, AesGcmHkdfStreamingKey.class, AesGcmHkdfStreamingKeyFormat.class, TYPE_URL);
    }

    @Override
    public StreamingAead getPrimitiveFromKey(AesGcmHkdfStreamingKey keyProto) throws GeneralSecurityException {
        return new AesGcmHkdfStreaming(keyProto.getKeyValue().toByteArray(), StreamingAeadUtil.toHmacAlgo(keyProto.getParams().getHkdfHashType()), keyProto.getParams().getDerivedKeySize(), keyProto.getParams().getCiphertextSegmentSize(), 0);
    }

    @Override
    public AesGcmHkdfStreamingKey newKeyFromFormat(AesGcmHkdfStreamingKeyFormat format) throws GeneralSecurityException {
        return (AesGcmHkdfStreamingKey)AesGcmHkdfStreamingKey.newBuilder().setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).setParams(format.getParams()).setVersion(0).build();
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    protected AesGcmHkdfStreamingKey parseKeyProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesGcmHkdfStreamingKey.parseFrom(byteString);
    }

    @Override
    protected AesGcmHkdfStreamingKeyFormat parseKeyFormatProto(ByteString byteString) throws InvalidProtocolBufferException {
        return AesGcmHkdfStreamingKeyFormat.parseFrom(byteString);
    }

    @Override
    protected void validateKey(AesGcmHkdfStreamingKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        this.validate(key.getParams());
    }

    @Override
    protected void validateKeyFormat(AesGcmHkdfStreamingKeyFormat format) throws GeneralSecurityException {
        if (format.getKeySize() < 16) {
            throw new GeneralSecurityException("key_size must be at least 16 bytes");
        }
        this.validate(format.getParams());
    }

    private void validate(AesGcmHkdfStreamingParams params) throws GeneralSecurityException {
        Validators.validateAesKeySize(params.getDerivedKeySize());
        if (params.getHkdfHashType() == HashType.UNKNOWN_HASH) {
            throw new GeneralSecurityException("unknown HKDF hash type");
        }
        if (params.getCiphertextSegmentSize() < params.getDerivedKeySize() + 8) {
            throw new GeneralSecurityException("ciphertext_segment_size must be at least (derived_key_size + 8)");
        }
    }
}

